/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Join;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Project;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.SemiJoin;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.rules.PushProjector;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelBuilderFactory;

public class ProjectJoinTransposeRule
extends RelOptRule {
    public static final ProjectJoinTransposeRule INSTANCE = new ProjectJoinTransposeRule(PushProjector.ExprCondition.TRUE, RelFactories.LOGICAL_BUILDER);
    private final PushProjector.ExprCondition preserveExprCondition;

    public ProjectJoinTransposeRule(PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relFactory) {
        super(ProjectJoinTransposeRule.operand(Project.class, ProjectJoinTransposeRule.operand(Join.class, ProjectJoinTransposeRule.any()), new RelOptRuleOperand[0]), relFactory, null);
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project origProj = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join instanceof SemiJoin) {
            return;
        }
        PushProjector pushProject = new PushProjector(origProj, join.getCondition(), join, this.preserveExprCondition, call.builder());
        if (pushProject.locateAllRefs()) {
            return;
        }
        Project leftProjRel = pushProject.createProjectRefsAndExprs(join.getLeft(), true, false);
        Project rightProjRel = pushProject.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (join.getCondition() != null) {
            ArrayList<RelDataTypeField> projJoinFieldList = new ArrayList<RelDataTypeField>();
            projJoinFieldList.addAll(join.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(join.getCondition(), projJoinFieldList, adjustments);
        }
        Join newJoinRel = join.copy(join.getTraitSet(), newJoinFilter, leftProjRel, rightProjRel, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProject.createNewProject(newJoinRel, adjustments);
        call.transformTo(topProject);
    }
}

