/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPCall;
import org.apache.beam.sdk.extensions.sql.impl.cep.Quantifier;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;

public class CEPPattern
implements Serializable {
    private final String patternVar;
    private final CEPCall patternCondition;
    private final Quantifier quant;

    private CEPPattern(String patternVar, @Nullable RexCall patternDef, Quantifier quant) {
        this.patternVar = patternVar;
        this.quant = quant;
        if (patternDef == null) {
            this.patternCondition = null;
            return;
        }
        this.patternCondition = CEPCall.of(patternDef);
    }

    public String toString() {
        return this.patternVar + this.quant.toString();
    }

    public CEPCall getPatternCondition() {
        return this.patternCondition;
    }

    public String getPatternVar() {
        return this.patternVar;
    }

    public Quantifier getQuantifier() {
        return this.quant;
    }

    public static CEPPattern of(Schema theSchema, String patternVar, RexCall patternDef, Quantifier quant) {
        return new CEPPattern(patternVar, patternDef, quant);
    }
}

