/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexBiVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCollation;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.CompositeList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.ConversionUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.DateString;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Litmus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.NlsString;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.SaffronProperties;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.TimeString;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.TimestampString;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class RexLiteral
extends RexNode {
    private final Comparable value;
    private final RelDataType type;
    private final SqlTypeName typeName;
    private static final ImmutableList<TimeUnit> TIME_UNITS = ImmutableList.copyOf(TimeUnit.values());

    RexLiteral(Comparable value, RelDataType type, SqlTypeName typeName) {
        this.value = value;
        this.type = Preconditions.checkNotNull(type);
        this.typeName = Preconditions.checkNotNull(typeName);
        Preconditions.checkArgument(RexLiteral.valueMatchesType(value, typeName, true));
        Preconditions.checkArgument(value == null == type.isNullable());
        Preconditions.checkArgument(typeName != SqlTypeName.ANY);
        this.digest = RexLiteral.toJavaString(value, typeName);
    }

    public static boolean valueMatchesType(Comparable value, SqlTypeName typeName, boolean strict) {
        if (value == null) {
            return true;
        }
        switch (typeName) {
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case NULL: {
                return false;
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case REAL: 
            case BIGINT: {
                return value instanceof BigDecimal;
            }
            case DATE: {
                return value instanceof DateString;
            }
            case TIME: {
                return value instanceof TimeString;
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return value instanceof TimeString;
            }
            case TIMESTAMP: {
                return value instanceof TimestampString;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return value instanceof TimestampString;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return value instanceof BigDecimal;
            }
            case VARBINARY: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case BINARY: {
                return value instanceof ByteString;
            }
            case VARCHAR: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case CHAR: {
                return value instanceof NlsString && ((NlsString)value).getCharset() != null && ((NlsString)value).getCollation() != null;
            }
            case SYMBOL: {
                return value instanceof Enum;
            }
            case ROW: 
            case MULTISET: {
                return value instanceof List;
            }
            case ANY: {
                return false;
            }
        }
        throw Util.unexpected(typeName);
    }

    private static String toJavaString(Comparable value, SqlTypeName typeName) {
        if (value == null) {
            return "null";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        RexLiteral.printAsJava(value, pw, typeName, false);
        pw.flush();
        return sw.toString();
    }

    public static boolean validConstant(Object o, Litmus litmus) {
        if (o == null || o instanceof BigDecimal || o instanceof NlsString || o instanceof ByteString) {
            return litmus.succeed();
        }
        if (o instanceof List) {
            List list = (List)o;
            for (Object o1 : list) {
                if (RexLiteral.validConstant(o1, litmus)) continue;
                return litmus.fail("not a constant: {}", o1);
            }
            return litmus.succeed();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                if (!RexLiteral.validConstant(entry.getKey(), litmus)) {
                    return litmus.fail("not a constant: {}", entry.getKey());
                }
                if (RexLiteral.validConstant(entry.getValue(), litmus)) continue;
                return litmus.fail("not a constant: {}", entry.getValue());
            }
            return litmus.succeed();
        }
        return litmus.fail("not a constant: {}", o);
    }

    private static List<TimeUnit> getTimeUnits(SqlTypeName typeName) {
        TimeUnit start = typeName.getStartUnit();
        TimeUnit end = typeName.getEndUnit();
        List list = TIME_UNITS.subList(start.ordinal(), end.ordinal() + 1);
        if (end == TimeUnit.SECOND) {
            return CompositeList.of(list, ImmutableList.of(TimeUnit.MILLISECOND));
        }
        return list;
    }

    private String intervalString(BigDecimal v) {
        List<TimeUnit> timeUnits = RexLiteral.getTimeUnits(this.type.getSqlTypeName());
        StringBuilder b = new StringBuilder();
        for (TimeUnit timeUnit : timeUnits) {
            BigDecimal[] result = v.divideAndRemainder(timeUnit.multiplier);
            if (b.length() > 0) {
                b.append(timeUnit.separator);
            }
            int width = b.length() == 0 ? -1 : RexLiteral.width(timeUnit);
            RexLiteral.pad(b, result[0].toString(), width);
            v = result[1];
        }
        if (Util.last(timeUnits) == TimeUnit.MILLISECOND) {
            while (b.toString().matches(".*\\.[0-9]*0")) {
                if (b.toString().endsWith(".0")) {
                    b.setLength(b.length() - 2);
                    continue;
                }
                b.setLength(b.length() - 1);
            }
        }
        return b.toString();
    }

    private static void pad(StringBuilder b, String s, int width) {
        if (width >= 0) {
            for (int i = s.length(); i < width; ++i) {
                b.append('0');
            }
        }
        b.append(s);
    }

    private static int width(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MILLISECOND: {
                return 3;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return 2;
            }
        }
        return -1;
    }

    public void printAsJava(PrintWriter pw) {
        RexLiteral.printAsJava(this.value, pw, this.typeName, true);
    }

    private static void printAsJava(Comparable value, PrintWriter pw, SqlTypeName typeName, boolean java) {
        switch (typeName) {
            case CHAR: {
                NlsString nlsString = (NlsString)value;
                if (java) {
                    Util.printJavaString(pw, nlsString.getValue(), true);
                    break;
                }
                boolean includeCharset = nlsString.getCharsetName() != null && !nlsString.getCharsetName().equals(SaffronProperties.INSTANCE.defaultCharset().get());
                pw.print(nlsString.asSql(includeCharset, false));
                break;
            }
            case BOOLEAN: {
                assert (value instanceof Boolean);
                pw.print((Boolean)value);
                break;
            }
            case DECIMAL: {
                assert (value instanceof BigDecimal);
                pw.print(value.toString());
                break;
            }
            case DOUBLE: {
                assert (value instanceof BigDecimal);
                pw.print(Util.toScientificNotation((BigDecimal)value));
                break;
            }
            case BIGINT: {
                assert (value instanceof BigDecimal);
                pw.print(((BigDecimal)value).longValue());
                pw.print('L');
                break;
            }
            case BINARY: {
                assert (value instanceof ByteString);
                pw.print("X'");
                pw.print(((ByteString)value).toString(16));
                pw.print("'");
                break;
            }
            case NULL: {
                assert (value == null);
                pw.print("null");
                break;
            }
            case SYMBOL: {
                assert (value instanceof Enum);
                pw.print("FLAG(");
                pw.print(value);
                pw.print(")");
                break;
            }
            case DATE: {
                assert (value instanceof DateString);
                pw.print(value);
                break;
            }
            case TIME: {
                assert (value instanceof TimeString);
                pw.print(value);
                break;
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                assert (value instanceof TimeString);
                pw.print(value);
                break;
            }
            case TIMESTAMP: {
                assert (value instanceof TimestampString);
                pw.print(value);
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                assert (value instanceof TimestampString);
                pw.print(value);
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                if (value instanceof BigDecimal) {
                    pw.print(value.toString());
                    break;
                }
                assert (value == null);
                pw.print("null");
                break;
            }
            case ROW: 
            case MULTISET: {
                final List list = (List)((Object)value);
                pw.print(new AbstractList<String>(){

                    @Override
                    public String get(int index) {
                        return ((RexLiteral)list.get((int)index)).digest;
                    }

                    @Override
                    public int size() {
                        return list.size();
                    }
                });
                break;
            }
            default: {
                assert (RexLiteral.valueMatchesType(value, typeName, true));
                throw Util.needToImplement((Object)typeName);
            }
        }
    }

    public static RexLiteral fromJdbcString(RelDataType type, SqlTypeName typeName, String literal) {
        if (literal == null) {
            return null;
        }
        switch (typeName) {
            case CHAR: {
                Charset charset = type.getCharset();
                SqlCollation collation = type.getCollation();
                NlsString str = new NlsString(literal, charset.name(), collation);
                return new RexLiteral(str, type, typeName);
            }
            case BOOLEAN: {
                boolean b = ConversionUtil.toBoolean(literal);
                return new RexLiteral(Boolean.valueOf(b), type, typeName);
            }
            case DECIMAL: 
            case DOUBLE: {
                BigDecimal d = new BigDecimal(literal);
                return new RexLiteral(d, type, typeName);
            }
            case BINARY: {
                byte[] bytes = ConversionUtil.toByteArrayFromString(literal, 16);
                return new RexLiteral(new ByteString(bytes), type, typeName);
            }
            case NULL: {
                return new RexLiteral(null, type, typeName);
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                long millis = SqlParserUtil.intervalToMillis(literal, type.getIntervalQualifier());
                return new RexLiteral(BigDecimal.valueOf(millis), type, typeName);
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                long months = SqlParserUtil.intervalToMonths(literal, type.getIntervalQualifier());
                return new RexLiteral(BigDecimal.valueOf(months), type, typeName);
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                Comparable<DateString> v;
                String format = RexLiteral.getCalendarFormat(typeName);
                TimeZone tz = DateTimeUtils.UTC_ZONE;
                block10 : switch (typeName) {
                    case DATE: {
                        Calendar cal = DateTimeUtils.parseDateFormat(literal, new SimpleDateFormat(format, Locale.ROOT), tz);
                        if (cal == null) {
                            throw new AssertionError((Object)("fromJdbcString: invalid date/time value '" + literal + "'"));
                        }
                        v = DateString.fromCalendarFields(cal);
                        break;
                    }
                    default: {
                        assert (format != null);
                        DateTimeUtils.PrecisionTime ts = DateTimeUtils.parsePrecisionDateTimeLiteral(literal, new SimpleDateFormat(format, Locale.ROOT), tz, -1);
                        if (ts == null) {
                            throw new AssertionError((Object)("fromJdbcString: invalid date/time value '" + literal + "'"));
                        }
                        switch (typeName) {
                            case TIMESTAMP: {
                                v = TimestampString.fromCalendarFields(ts.getCalendar()).withFraction(ts.getFraction());
                                break block10;
                            }
                            case TIME: {
                                v = TimeString.fromCalendarFields(ts.getCalendar()).withFraction(ts.getFraction());
                                break block10;
                            }
                        }
                        throw new AssertionError();
                    }
                }
                return new RexLiteral(v, type, typeName);
            }
        }
        throw new AssertionError((Object)"fromJdbcString: unsupported type");
    }

    private static String getCalendarFormat(SqlTypeName typeName) {
        switch (typeName) {
            case DATE: {
                return "yyyy-MM-dd";
            }
            case TIME: {
                return "HH:mm:ss";
            }
            case TIMESTAMP: {
                return "yyyy-MM-dd HH:mm:ss";
            }
        }
        throw new AssertionError((Object)"getCalendarFormat: unknown type");
    }

    public SqlTypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LITERAL;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Comparable getValue() {
        assert (RexLiteral.valueMatchesType(this.value, this.typeName, true)) : this.value;
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return this.getValueAs(Calendar.class);
            }
        }
        return this.value;
    }

    public Object getValue2() {
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case CHAR: {
                return this.getValueAs(String.class);
            }
            case DECIMAL: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.getValueAs(Long.class);
            }
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return this.getValueAs(Integer.class);
            }
        }
        return this.value;
    }

    public Object getValue3() {
        switch (this.typeName) {
            case DECIMAL: {
                assert (this.value instanceof BigDecimal);
                return this.value;
            }
        }
        return this.getValue2();
    }

    public <T> T getValueAs(Class<T> clazz) {
        if (this.value == null || clazz.isInstance(this.value)) {
            return clazz.cast(this.value);
        }
        switch (this.typeName) {
            case BINARY: {
                if (clazz != byte[].class) break;
                return clazz.cast(((ByteString)this.value).getBytes());
            }
            case CHAR: {
                if (clazz == String.class) {
                    return clazz.cast(((NlsString)this.value).getValue());
                }
                if (clazz != Character.class) break;
                return clazz.cast(Character.valueOf(((NlsString)this.value).getValue().charAt(0)));
            }
            case VARCHAR: {
                if (clazz != String.class) break;
                return clazz.cast(((NlsString)this.value).getValue());
            }
            case DECIMAL: {
                if (clazz == Long.class) {
                    return clazz.cast(((BigDecimal)this.value).unscaledValue().longValue());
                }
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: 
            case DOUBLE: 
            case FLOAT: 
            case REAL: 
            case BIGINT: {
                if (clazz == Long.class) {
                    return clazz.cast(((BigDecimal)this.value).longValue());
                }
                if (clazz == Integer.class) {
                    return clazz.cast(((BigDecimal)this.value).intValue());
                }
                if (clazz == Short.class) {
                    return clazz.cast(((BigDecimal)this.value).shortValue());
                }
                if (clazz == Byte.class) {
                    return clazz.cast(((BigDecimal)this.value).byteValue());
                }
                if (clazz == Double.class) {
                    return clazz.cast(((BigDecimal)this.value).doubleValue());
                }
                if (clazz != Float.class) break;
                return clazz.cast(Float.valueOf(((BigDecimal)this.value).floatValue()));
            }
            case DATE: {
                if (clazz == Integer.class) {
                    return clazz.cast(((DateString)this.value).getDaysSinceEpoch());
                }
                if (clazz != Calendar.class) break;
                return clazz.cast(((DateString)this.value).toCalendar());
            }
            case TIME: {
                if (clazz == Integer.class) {
                    return clazz.cast(((TimeString)this.value).getMillisOfDay());
                }
                if (clazz != Calendar.class) break;
                return clazz.cast(((TimeString)this.value).toCalendar());
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                if (clazz != Integer.class) break;
                return clazz.cast(((TimeString)this.value).getMillisOfDay());
            }
            case TIMESTAMP: {
                if (clazz == Long.class) {
                    return clazz.cast(((TimestampString)this.value).getMillisSinceEpoch());
                }
                if (clazz != Calendar.class) break;
                return clazz.cast(((TimestampString)this.value).toCalendar());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (clazz != Long.class) break;
                return clazz.cast(((TimestampString)this.value).getMillisSinceEpoch());
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                if (clazz == Integer.class) {
                    return clazz.cast(((BigDecimal)this.value).intValue());
                }
                if (clazz == Long.class) {
                    return clazz.cast(((BigDecimal)this.value).longValue());
                }
                if (clazz == String.class) {
                    return clazz.cast(this.intervalString(this.getValueAs(BigDecimal.class).abs()));
                }
                if (clazz != Boolean.class) break;
                return clazz.cast(this.getValueAs(BigDecimal.class).signum() < 0);
            }
        }
        throw new AssertionError((Object)("cannot convert " + (Object)((Object)this.typeName) + " literal to " + clazz));
    }

    public static boolean booleanValue(RexNode node) {
        return (Boolean)((RexLiteral)node).value;
    }

    @Override
    public boolean isAlwaysTrue() {
        if (this.typeName != SqlTypeName.BOOLEAN) {
            return false;
        }
        return RexLiteral.booleanValue(this);
    }

    @Override
    public boolean isAlwaysFalse() {
        if (this.typeName != SqlTypeName.BOOLEAN) {
            return false;
        }
        return !RexLiteral.booleanValue(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof RexLiteral && RexLiteral.equals(((RexLiteral)obj).value, this.value) && RexLiteral.equals(((RexLiteral)obj).type, this.type);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public static Comparable value(RexNode node) {
        return RexLiteral.findValue(node);
    }

    public static int intValue(RexNode node) {
        Comparable value = RexLiteral.findValue(node);
        return ((Number)((Object)value)).intValue();
    }

    public static String stringValue(RexNode node) {
        Comparable value = RexLiteral.findValue(node);
        return value == null ? null : ((NlsString)value).getValue();
    }

    private static Comparable findValue(RexNode node) {
        if (node instanceof RexLiteral) {
            return ((RexLiteral)node).value;
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.CAST) {
                return RexLiteral.findValue(call.getOperands().get(0));
            }
            if (operator == SqlStdOperatorTable.UNARY_MINUS) {
                BigDecimal value = (BigDecimal)RexLiteral.findValue(call.getOperands().get(0));
                return value.negate();
            }
        }
        throw new AssertionError((Object)("not a literal: " + node));
    }

    public static boolean isNullLiteral(RexNode node) {
        return node instanceof RexLiteral && ((RexLiteral)node).value == null;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitLiteral(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitLiteral(this, arg);
    }
}

