/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.rules;

import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Join;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinInfo;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.SemiJoin;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RelBuilderFactory;

public class JoinAddRedundantSemiJoinRule
extends RelOptRule {
    public static final JoinAddRedundantSemiJoinRule INSTANCE = new JoinAddRedundantSemiJoinRule(LogicalJoin.class, RelFactories.LOGICAL_BUILDER);

    public JoinAddRedundantSemiJoinRule(Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory) {
        super(JoinAddRedundantSemiJoinRule.operand(clazz, JoinAddRedundantSemiJoinRule.any()), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join origJoinRel = (Join)call.rel(0);
        if (origJoinRel.isSemiJoinDone()) {
            return;
        }
        if (origJoinRel.getJoinType() != JoinRelType.INNER) {
            return;
        }
        JoinInfo joinInfo = origJoinRel.analyzeCondition();
        if (joinInfo.leftKeys.size() == 0) {
            return;
        }
        SemiJoin semiJoin = SemiJoin.create(origJoinRel.getLeft(), origJoinRel.getRight(), origJoinRel.getCondition(), joinInfo.leftKeys, joinInfo.rightKeys);
        Join newJoinRel = origJoinRel.copy(origJoinRel.getTraitSet(), origJoinRel.getCondition(), semiJoin, origJoinRel.getRight(), JoinRelType.INNER, true);
        call.transformTo(newJoinRel);
    }
}

