/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.remote;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.Meta;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.MetaImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.remote.ProtobufService;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.remote.Service;

public class MockProtobufService
extends ProtobufService {
    private final String connectionId;
    private final Map<Service.Request, Service.Response> mapping;

    public MockProtobufService(String connectionId) {
        this.connectionId = connectionId;
        this.mapping = this.createMapping();
    }

    private Map<Service.Request, Service.Response> createMapping() {
        HashMap<Service.Request, Service.Response> mappings = new HashMap<Service.Request, Service.Response>();
        mappings.put(new Service.OpenConnectionRequest(this.connectionId, new HashMap<String, String>()), new Service.OpenConnectionResponse());
        mappings.put(new Service.SchemasRequest(this.connectionId, null, null), new Service.ResultSetResponse(null, 1, false, null, Meta.Frame.EMPTY, -1L, null));
        mappings.put(new Service.TablesRequest(this.connectionId, null, null, null, Collections.emptyList()), new Service.ResultSetResponse(null, 150, false, null, Meta.Frame.EMPTY, -1L, null));
        mappings.put(new Service.CreateStatementRequest("0"), new Service.CreateStatementResponse("0", 1, null));
        mappings.put(new Service.PrepareAndExecuteRequest(this.connectionId, 1, "select * from (\\n values (1, 'a'), (null, 'b'), (3, 'c')) as t (c1, c2)", -1L), new Service.ResultSetResponse("0", 1, true, Meta.Signature.create(Arrays.asList(MetaImpl.columnMetaData("C1", 0, Integer.class, true), MetaImpl.columnMetaData("C2", 1, String.class, true)), null, null, Meta.CursorFactory.ARRAY, Meta.StatementType.SELECT), Meta.Frame.create(0L, true, Arrays.asList(new Object[]{1, "a"}, new Object[]{null, "b"}, new Object[]{3, "c"})), -1L, null));
        mappings.put(new Service.PrepareRequest(this.connectionId, "select * from (\\n values(1, 'a'), (null, 'b'), (3, 'c')), as t (c1, c2)", -1L), new Service.ResultSetResponse("0", 1, true, Meta.Signature.create(Arrays.asList(MetaImpl.columnMetaData("C1", 0, Integer.class, true), MetaImpl.columnMetaData("C2", 1, String.class, true)), null, Collections.emptyList(), Meta.CursorFactory.ARRAY, Meta.StatementType.SELECT), null, -1L, null));
        mappings.put(new Service.ColumnsRequest(this.connectionId, null, null, "my_table", null), new Service.ResultSetResponse("00000000-0000-0000-0000-000000000000", -1, true, Meta.Signature.create(Arrays.asList(MetaImpl.columnMetaData("TABLE_NAME", 0, String.class, true), MetaImpl.columnMetaData("ORDINAL_POSITION", 1, Long.class, true)), null, Collections.emptyList(), Meta.CursorFactory.ARRAY, null), Meta.Frame.create(0L, true, Arrays.asList(new Object[]{new Object[]{"my_table", 10}})), -1L, null));
        return Collections.unmodifiableMap(mappings);
    }

    @Override
    public Service.Response _apply(Service.Request request) {
        if (request instanceof Service.CloseConnectionRequest) {
            return new Service.CloseConnectionResponse();
        }
        return this.dispatch(request);
    }

    private Service.Response dispatch(Service.Request request) {
        Service.Response response = this.mapping.get(request);
        if (null == response) {
            throw new RuntimeException("Had no response mapping for " + request);
        }
        return response;
    }

    public static class MockProtobufServiceFactory
    implements Service.Factory {
        @Override
        public Service create(AvaticaConnection connection) {
            return new MockProtobufService(connection.id);
        }
    }
}

