/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowType;
import org.apache.commons.csv.CSVFormat;

public class BeamTextCSVTableIOWriter
extends PTransform<PCollection<Row>, PDone>
implements Serializable {
    private String filePattern;
    protected RowType rowType;
    protected CSVFormat csvFormat;

    public BeamTextCSVTableIOWriter(RowType rowType, String filePattern, CSVFormat csvFormat) {
        this.filePattern = filePattern;
        this.rowType = rowType;
        this.csvFormat = csvFormat;
    }

    public PDone expand(PCollection<Row> input) {
        return (PDone)((PCollection)input.apply("encodeRecord", (PTransform)ParDo.of((DoFn)new DoFn<Row, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) {
                Row row = (Row)ctx.element();
                ctx.output((Object)BeamTableUtils.beamRow2CsvLine(row, BeamTextCSVTableIOWriter.this.csvFormat));
            }
        }))).apply((PTransform)TextIO.write().to(this.filePattern));
    }
}

