/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSinkRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.Convention;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.prepare.Prepare;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Table;

public class BeamIOSinkRule
extends ConverterRule {
    private final BeamSqlEnv sqlEnv;

    public static BeamIOSinkRule forSqlEnv(BeamSqlEnv sqlEnv) {
        return new BeamIOSinkRule(sqlEnv);
    }

    private BeamIOSinkRule(BeamSqlEnv sqlEnv) {
        super(LogicalTableModify.class, Convention.NONE, BeamLogicalConvention.INSTANCE, "BeamIOSinkRule");
        this.sqlEnv = sqlEnv;
    }

    @Override
    public RelNode convert(RelNode rel) {
        TableModify tableModify = (TableModify)rel;
        RelNode input = tableModify.getInput();
        RelOptCluster cluster = tableModify.getCluster();
        RelTraitSet traitSet = tableModify.getTraitSet().replace(BeamLogicalConvention.INSTANCE);
        RelOptTable relOptTable = tableModify.getTable();
        Prepare.CatalogReader catalogReader = tableModify.getCatalogReader();
        RelNode convertedInput = BeamIOSinkRule.convert(input, input.getTraitSet().replace(BeamLogicalConvention.INSTANCE));
        TableModify.Operation operation = tableModify.getOperation();
        List<String> updateColumnList = tableModify.getUpdateColumnList();
        List<RexNode> sourceExpressionList = tableModify.getSourceExpressionList();
        boolean flattened = tableModify.isFlattened();
        Table table = tableModify.getTable().unwrap(Table.class);
        switch (table.getJdbcTableType()) {
            case TABLE: 
            case STREAM: {
                if (operation != TableModify.Operation.INSERT) {
                    throw new UnsupportedOperationException(String.format("Streams doesn't support %s modify operation", new Object[]{operation}));
                }
                return new BeamIOSinkRel(this.sqlEnv, cluster, traitSet, relOptTable, catalogReader, convertedInput, operation, updateColumnList, sourceExpressionList, flattened);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported table type: %s", new Object[]{table.getJdbcTableType()}));
    }
}

