/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public abstract class BeamSqlMathBinaryExpression
extends BeamSqlExpression {
    public BeamSqlMathBinaryExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    @Override
    public boolean accept() {
        return this.numberOfOperands() == 2 && this.isOperandNumeric(this.opType(0)) && this.isOperandNumeric(this.opType(1));
    }

    @Override
    public BeamSqlPrimitive<? extends Number> evaluate(Row inputRow, BoundedWindow window) {
        BeamSqlExpression leftOp = this.op(0);
        BeamSqlExpression rightOp = this.op(1);
        return this.calculate(leftOp.evaluate(inputRow, window), rightOp.evaluate(inputRow, window));
    }

    public abstract BeamSqlPrimitive<? extends Number> calculate(BeamSqlPrimitive var1, BeamSqlPrimitive var2);

    public boolean isOperandNumeric(SqlTypeName opType) {
        return SqlTypeName.NUMERIC_TYPES.contains((Object)opType);
    }
}

