/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.util.Date;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlExtractExpression
extends BeamSqlExpression {
    public BeamSqlExtractExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.BIGINT);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2 && this.opType(1) == SqlTypeName.TIMESTAMP;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window) {
        Date time = (Date)this.opValueEvaluated(1, inputRow, window);
        TimeUnitRange unit = (TimeUnitRange)((Object)((BeamSqlPrimitive)this.op(0)).getValue());
        switch (unit) {
            case YEAR: 
            case QUARTER: 
            case MONTH: 
            case DAY: 
            case DOW: 
            case WEEK: 
            case DOY: 
            case CENTURY: 
            case MILLENNIUM: {
                Long timeByDay = time.getTime() / 86400000L;
                Long extracted = DateTimeUtils.unixDateExtract(unit, timeByDay);
                return BeamSqlPrimitive.of(this.outputType, extracted);
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                int timeInDay = (int)(time.getTime() % 86400000L);
                Long extracted = DateTimeUtils.unixTimeExtract(unit, timeInDay);
                return BeamSqlPrimitive.of(this.outputType, extracted);
            }
        }
        throw new UnsupportedOperationException("Extract for time unit: " + (Object)((Object)unit) + " not supported!");
    }
}

