/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.util.Date;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlDateCeilExpression
extends BeamSqlExpression {
    public BeamSqlDateCeilExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.TIMESTAMP);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2 && this.opType(1) == SqlTypeName.SYMBOL;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window) {
        Date date = (Date)this.opValueEvaluated(0, inputRow, window);
        long time = date.getTime();
        TimeUnitRange unit = (TimeUnitRange)((Object)((BeamSqlPrimitive)this.op(1)).getValue());
        long newTime = DateTimeUtils.unixTimestampCeil(unit, time);
        Date newDate = new Date(newTime);
        return BeamSqlPrimitive.of(this.outputType, newDate);
    }
}

