/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.SqlTypeCoder;
import org.apache.beam.sdk.extensions.sql.SqlTypeCoders;
import org.apache.beam.sdk.values.RowType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;

public class RowSqlType {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableList.Builder<RowType.Field> fields = ImmutableList.builder();

        public Builder withField(String fieldName, SqlTypeCoder fieldCoder) {
            this.fields.add((Object)RowType.newField((String)fieldName, (Coder)fieldCoder));
            return this;
        }

        public Builder withTinyIntField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.TINYINT);
        }

        public Builder withSmallIntField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.SMALLINT);
        }

        public Builder withIntegerField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.INTEGER);
        }

        public Builder withBigIntField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.BIGINT);
        }

        public Builder withFloatField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.FLOAT);
        }

        public Builder withDoubleField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.DOUBLE);
        }

        public Builder withDecimalField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.DECIMAL);
        }

        public Builder withBooleanField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.BOOLEAN);
        }

        public Builder withCharField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.CHAR);
        }

        public Builder withVarcharField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.VARCHAR);
        }

        public Builder withTimeField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.TIME);
        }

        public Builder withDateField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.DATE);
        }

        public Builder withTimestampField(String fieldName) {
            return this.withField(fieldName, SqlTypeCoders.TIMESTAMP);
        }

        private Builder() {
        }

        public RowType build() {
            return (RowType)this.fields.build().stream().collect(RowType.toRowType());
        }
    }
}

