/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamEnumerableConverter;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSinkRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.Queryable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.prepare.Prepare;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.ModifiableTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.TranslatableTable;

public class BeamCalciteTable
extends AbstractQueryableTable
implements ModifiableTable,
TranslatableTable {
    private final BeamSqlTable beamTable;
    private final Map<String, String> pipelineOptionsMap;
    private PipelineOptions pipelineOptions;

    BeamCalciteTable(BeamSqlTable beamTable, Map<String, String> pipelineOptionsMap, PipelineOptions pipelineOptions) {
        super(Object[].class);
        this.beamTable = beamTable;
        this.pipelineOptionsMap = pipelineOptionsMap;
        this.pipelineOptions = pipelineOptions;
    }

    public static BeamCalciteTable of(BeamSqlTable table) {
        return new BeamCalciteTable(table, (Map<String, String>)ImmutableMap.of(), null);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return CalciteUtils.toCalciteRowType(this.beamTable.getSchema(), typeFactory);
    }

    private PipelineOptions getPipelineOptions() {
        if (this.pipelineOptions != null) {
            return this.pipelineOptions;
        }
        this.pipelineOptions = BeamEnumerableConverter.createPipelineOptions(this.pipelineOptionsMap);
        return this.pipelineOptions;
    }

    public BeamTableStatistics getStatistic() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(BeamEnumerableConverter.class.getClassLoader());
            BeamTableStatistics beamTableStatistics = this.beamTable.getTableStatistics(this.getPipelineOptions());
            return beamTableStatistics;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new BeamIOSourceRel(context.getCluster(), context.getCluster().traitSetOf((RelTrait)BeamLogicalConvention.INSTANCE), relOptTable, this.beamTable, this.pipelineOptionsMap, this);
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public Collection getModifiableCollection() {
        return null;
    }

    public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        return new BeamIOSinkRel(cluster, table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened, this.beamTable, this.pipelineOptionsMap);
    }
}

