/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface BeamRelNode
extends RelNode {
    default public PCollection.IsBounded isBounded() {
        return this.getPCollectionInputs().stream().allMatch(rel -> BeamSqlRelUtils.getBeamRelInput(rel).isBounded() == PCollection.IsBounded.BOUNDED) ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED;
    }

    default public void withErrorsTransformer(@Nullable PTransform<PCollection<Row>, POutput> ptransform) {
    }

    default public List<RelNode> getPCollectionInputs() {
        return this.getInputs();
    }

    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform();

    default public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform(@Nullable PTransform<PCollection<Row>, ? extends POutput> errorsTransformer) {
        return this.buildPTransform();
    }

    default public Map<String, String> getPipelineOptions() {
        Map<String, String> options = null;
        for (RelNode input : this.getInputs()) {
            Map<String, String> inputOptions = ((BeamRelNode)input).getPipelineOptions();
            if (!1.$assertionsDisabled && inputOptions == null) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && options != null && options != inputOptions) {
                throw new AssertionError();
            }
            options = inputOptions;
        }
        return options;
    }

    public NodeStats estimateNodeStats(BeamRelMetadataQuery var1);

    public BeamCostModel beamComputeSelfCost(RelOptPlanner var1, BeamRelMetadataQuery var2);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

