/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.planner;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.extensions.sql.impl.planner.AutoValue_NodeStats;

@AutoValue
public abstract class NodeStats {
    public static final NodeStats UNKNOWN = NodeStats.create(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public abstract double getRowCount();

    public abstract double getRate();

    public abstract double getWindow();

    public static NodeStats create(double rowCount, double rate, double window) {
        if (window < 0.0 || rate < 0.0 || rowCount < 0.0) {
            throw new IllegalArgumentException("All the estimates in NodeStats should be positive");
        }
        return new AutoValue_NodeStats(rowCount, rate, window);
    }

    public static NodeStats create(double rowCount) {
        return NodeStats.create(rowCount, 0.0, rowCount);
    }

    public boolean isUnknown() {
        return Double.isInfinite(this.getRowCount()) || Double.isInfinite(this.getRate()) || Double.isInfinite(this.getWindow());
    }

    public NodeStats multiply(double factor) {
        return NodeStats.create(this.getRowCount() * factor, this.getRate() * factor, this.getWindow() * factor);
    }

    public NodeStats plus(NodeStats that) {
        if (this.isUnknown() || that.isUnknown()) {
            return UNKNOWN;
        }
        return NodeStats.create(this.getRowCount() + that.getRowCount(), this.getRate() + that.getRate(), this.getWindow() + that.getWindow());
    }

    public NodeStats minus(NodeStats that) {
        if (this.isUnknown() || that.isUnknown()) {
            return UNKNOWN;
        }
        return NodeStats.create(Math.max(this.getRowCount() - that.getRowCount(), 0.0), Math.max(this.getRate() - that.getRate(), 0.0), Math.max(this.getWindow() - that.getWindow(), 0.0));
    }
}

