/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Map;
import java.util.Properties;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchemaFactory;
import org.apache.beam.sdk.extensions.sql.impl.CalciteFactoryWrapper;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelDataTypeSystem;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.AvaticaFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.ConnectionProperty;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.Lex;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.checkerframework.checker.nullness.qual.Nullable;

class JdbcFactory
extends CalciteFactoryWrapper {
    JdbcFactory(CalciteFactory factory) {
        super(factory);
    }

    static JdbcFactory wrap(CalciteFactory calciteFactory) {
        return new JdbcFactory(calciteFactory);
    }

    @Override
    public AvaticaConnection newConnection(UnregisteredDriver driver, AvaticaFactory avaticaFactory, String url, Properties info, @Nullable CalciteSchema rootSchema, @Nullable JavaTypeFactory typeFactory) {
        Properties connectionProps = this.ensureDefaultProperties(info);
        CalciteSchema actualRootSchema = rootSchema;
        if (rootSchema == null) {
            actualRootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false, (String)"");
        }
        return super.newConnection(driver, avaticaFactory, url, connectionProps, actualRootSchema, typeFactory);
    }

    private Properties ensureDefaultProperties(Properties originalInfo) {
        Properties info = new Properties();
        info.putAll((Map<?, ?>)originalInfo);
        JdbcFactory.setIfNull(info, (ConnectionProperty)BuiltInConnectionProperty.TIME_ZONE, "UTC");
        JdbcFactory.setIfNull(info, (ConnectionProperty)CalciteConnectionProperty.LEX, Lex.JAVA.name());
        JdbcFactory.setIfNull(info, (ConnectionProperty)CalciteConnectionProperty.PARSER_FACTORY, BeamSqlParser.class.getName() + "#FACTORY");
        JdbcFactory.setIfNull(info, (ConnectionProperty)CalciteConnectionProperty.TYPE_SYSTEM, BeamRelDataTypeSystem.class.getName());
        JdbcFactory.setIfNull(info, (ConnectionProperty)CalciteConnectionProperty.SCHEMA, "beam");
        JdbcFactory.setIfNull(info, (ConnectionProperty)CalciteConnectionProperty.SCHEMA_FACTORY, BeamCalciteSchemaFactory.AllProviders.class.getName());
        JdbcFactory.setIfNull(info, "beam.userAgent", "BeamSQL/" + ReleaseInfo.getReleaseInfo().getVersion());
        return info;
    }

    private static void setIfNull(Properties info, ConnectionProperty key, String value) {
        JdbcFactory.setIfNull(info, key.camelName(), value);
    }

    private static void setIfNull(Properties info, String key, String value) {
        if (info.getProperty(key) == null) {
            info.setProperty(key, value);
        }
    }
}

