/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPLiteral;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperation;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;

public class CEPCall
extends CEPOperation {
    private final CEPOperator operator;
    private final List<CEPOperation> operands;

    private CEPCall(CEPOperator operator, List<CEPOperation> operands) {
        this.operator = operator;
        this.operands = operands;
    }

    public CEPOperator getOperator() {
        return this.operator;
    }

    public List<CEPOperation> getOperands() {
        return this.operands;
    }

    public static CEPCall of(RexCall operation) {
        SqlOperator call = operation.getOperator();
        CEPOperator myOp = CEPOperator.of(call);
        ArrayList<CEPOperation> operandsList = new ArrayList<CEPOperation>();
        for (RexNode i : operation.getOperands()) {
            if (i.getClass() == RexCall.class) {
                CEPCall callToAdd = CEPCall.of((RexCall)i);
                operandsList.add(callToAdd);
                continue;
            }
            if (i.getClass() == RexLiteral.class) {
                RexLiteral lit = (RexLiteral)i;
                CEPLiteral litToAdd = CEPLiteral.of(lit);
                operandsList.add(litToAdd);
                continue;
            }
            if (i.getClass() == RexPatternFieldRef.class) {
                RexPatternFieldRef fieldRef = (RexPatternFieldRef)i;
                CEPFieldRef fieldRefToAdd = CEPFieldRef.of(fieldRef);
                operandsList.add(fieldRefToAdd);
                continue;
            }
            throw new UnsupportedOperationException("RexNode not supported: " + i.getClass().getName());
        }
        return new CEPCall(myOp, operandsList);
    }

    public String toString() {
        ArrayList<String> operandStrings = new ArrayList<String>();
        for (CEPOperation i : this.operands) {
            operandStrings.add(i.toString());
        }
        return this.operator.toString() + "(" + String.join((CharSequence)", ", operandStrings) + ")";
    }
}

