/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.BeamSqlSeekableTable;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.calcite.v1_26_0.com.google.common.base.Optional;
import org.apache.beam.vendor.calcite.v1_26_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.core.Join;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexFieldAccess;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.util.Pair;

public abstract class BeamJoinRel
extends Join
implements BeamRelNode {
    protected BeamJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traits, left, right, condition, variablesSet, joinType);
    }

    @Override
    public List<RelNode> getPCollectionInputs() {
        if (this.isSideInputLookupJoin()) {
            return ImmutableList.of((Object)BeamSqlRelUtils.getBeamRelInput((RelNode)this.getInputs().get((Integer)this.nonSeekableInputIndex().get())));
        }
        return BeamRelNode.super.getPCollectionInputs();
    }

    protected boolean isSideInputLookupJoin() {
        return this.seekableInputIndex().isPresent() && this.nonSeekableInputIndex().isPresent();
    }

    protected Optional<Integer> seekableInputIndex() {
        BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(this.left);
        BeamRelNode rightRelNode = BeamSqlRelUtils.getBeamRelInput(this.right);
        return BeamJoinRel.seekable(leftRelNode) ? Optional.of((Object)0) : (BeamJoinRel.seekable(rightRelNode) ? Optional.of((Object)1) : Optional.absent());
    }

    protected Optional<Integer> nonSeekableInputIndex() {
        BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(this.left);
        BeamRelNode rightRelNode = BeamSqlRelUtils.getBeamRelInput(this.right);
        return !BeamJoinRel.seekable(leftRelNode) ? Optional.of((Object)0) : (!BeamJoinRel.seekable(rightRelNode) ? Optional.of((Object)1) : Optional.absent());
    }

    public static boolean seekable(BeamRelNode relNode) {
        BeamIOSourceRel srcRel;
        BeamSqlTable sourceTable;
        return relNode instanceof BeamIOSourceRel && (sourceTable = (srcRel = (BeamIOSourceRel)relNode).getBeamSqlTable()) instanceof BeamSqlSeekableTable;
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        NodeStats leftEstimates = BeamSqlRelUtils.getNodeStats(this.left, mq);
        NodeStats rightEstimates = BeamSqlRelUtils.getNodeStats(this.right, mq);
        NodeStats selfEstimates = BeamSqlRelUtils.getNodeStats(this, mq);
        NodeStats summation = selfEstimates.plus(leftEstimates).plus(rightEstimates);
        return BeamCostModel.FACTORY.makeCost(summation.getRowCount(), summation.getRate());
    }

    @Override
    public NodeStats estimateNodeStats(RelMetadataQuery mq) {
        double selectivity = mq.getSelectivity((RelNode)this, this.getCondition());
        NodeStats leftEstimates = BeamSqlRelUtils.getNodeStats(this.left, mq);
        NodeStats rightEstimates = BeamSqlRelUtils.getNodeStats(this.right, mq);
        if (leftEstimates.isUnknown() || rightEstimates.isUnknown()) {
            return NodeStats.UNKNOWN;
        }
        return NodeStats.create(leftEstimates.getRowCount() * rightEstimates.getRowCount() * selectivity, (leftEstimates.getRate() * rightEstimates.getWindow() + rightEstimates.getRate() * leftEstimates.getWindow()) * selectivity, leftEstimates.getWindow() * rightEstimates.getWindow() * selectivity);
    }

    public static boolean isJoinLegal(Join join) {
        try {
            BeamJoinRel.extractJoinRexNodes(join.getCondition());
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    static List<Pair<RexNode, RexNode>> extractJoinRexNodes(RexNode condition) {
        if (condition instanceof RexLiteral) {
            throw new UnsupportedOperationException("CROSS JOIN, JOIN ON FALSE is not supported!");
        }
        RexCall call = (RexCall)condition;
        ArrayList<Pair<RexNode, RexNode>> pairs = new ArrayList<Pair<RexNode, RexNode>>();
        if ("AND".equals(call.getOperator().getName())) {
            List operands = call.getOperands();
            for (RexNode rexNode : operands) {
                Pair<RexNode, RexNode> pair = BeamJoinRel.extractJoinPairOfRexNodes((RexCall)rexNode);
                pairs.add(pair);
            }
        } else if ("=".equals(call.getOperator().getName())) {
            pairs.add(BeamJoinRel.extractJoinPairOfRexNodes(call));
        } else {
            throw new UnsupportedOperationException("Operator " + call.getOperator().getName() + " is not supported in join condition");
        }
        return pairs;
    }

    private static Pair<RexNode, RexNode> extractJoinPairOfRexNodes(RexCall rexCall) {
        int rightIndex;
        if (!rexCall.getOperator().getName().equals("=")) {
            throw new UnsupportedOperationException("Non equi-join is not supported");
        }
        if (BeamJoinRel.isIllegalJoinConjunctionClause(rexCall)) {
            throw new UnsupportedOperationException("Only support column reference or struct field access in conjunction clause");
        }
        int leftIndex = BeamJoinRel.getColumnIndex((RexNode)rexCall.getOperands().get(0));
        if (leftIndex < (rightIndex = BeamJoinRel.getColumnIndex((RexNode)rexCall.getOperands().get(1)))) {
            return new Pair((Object)((RexNode)rexCall.getOperands().get(0)), (Object)((RexNode)rexCall.getOperands().get(1)));
        }
        return new Pair((Object)((RexNode)rexCall.getOperands().get(1)), (Object)((RexNode)rexCall.getOperands().get(0)));
    }

    private static boolean isIllegalJoinConjunctionClause(RexCall rexCall) {
        return !(rexCall.getOperands().get(0) instanceof RexInputRef) && !(rexCall.getOperands().get(0) instanceof RexFieldAccess) || !(rexCall.getOperands().get(1) instanceof RexInputRef) && !(rexCall.getOperands().get(1) instanceof RexFieldAccess);
    }

    private static int getColumnIndex(RexNode rexNode) {
        if (rexNode instanceof RexInputRef) {
            return ((RexInputRef)rexNode).getIndex();
        }
        if (rexNode instanceof RexFieldAccess) {
            return BeamJoinRel.getColumnIndex(((RexFieldAccess)rexNode).getReferenceExpr());
        }
        throw new UnsupportedOperationException("Cannot get column index from " + rexNode.getType());
    }

    public static PCollection.IsBounded getBoundednessOfRelNode(RelNode relNode) {
        if (relNode instanceof BeamRelNode) {
            return ((BeamRelNode)relNode).isBounded();
        }
        ArrayList<PCollection.IsBounded> boundednessOfInputs = new ArrayList<PCollection.IsBounded>();
        for (RelNode inputRel : relNode.getInputs()) {
            if (inputRel instanceof RelSubset) {
                RelNode rel = ((RelSubset)inputRel).getBest();
                if (rel == null) {
                    rel = (RelNode)((RelSubset)inputRel).getRelList().get(0);
                }
                boundednessOfInputs.add(BeamJoinRel.getBoundednessOfRelNode(rel));
                continue;
            }
            boundednessOfInputs.add(BeamJoinRel.getBoundednessOfRelNode(inputRel));
        }
        return boundednessOfInputs.contains(PCollection.IsBounded.UNBOUNDED) ? PCollection.IsBounded.UNBOUNDED : PCollection.IsBounded.BOUNDED;
    }

    public static boolean containsSeekableInput(RelNode relNode) {
        for (RelNode relInput : relNode.getInputs()) {
            if (relInput instanceof RelSubset) {
                relInput = ((RelSubset)relInput).getBest();
            }
            if (relInput == null || !(relInput instanceof BeamRelNode) || !BeamJoinRel.seekable((BeamRelNode)relInput)) continue;
            return true;
        }
        return false;
    }
}

