/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.TypeDescriptor;

@Experimental
public class TypedCombineFnDelegate<InputT, AccumT, OutputT>
extends Combine.CombineFn<InputT, AccumT, OutputT> {
    private final Combine.CombineFn<InputT, AccumT, OutputT> delegate;

    protected TypedCombineFnDelegate(Combine.CombineFn<InputT, AccumT, OutputT> delegate) {
        this.delegate = delegate;
    }

    public TypeDescriptor<OutputT> getOutputType() {
        return Optional.ofNullable(this.getGenericSuperTypeAtIndex(2)).orElse(this.delegate.getOutputType());
    }

    public TypeDescriptor<InputT> getInputType() {
        return Optional.ofNullable(this.getGenericSuperTypeAtIndex(0)).orElse(this.delegate.getInputType());
    }

    public AccumT createAccumulator() {
        return (AccumT)this.delegate.createAccumulator();
    }

    public AccumT addInput(AccumT mutableAccumulator, InputT input) {
        return (AccumT)this.delegate.addInput(mutableAccumulator, input);
    }

    public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
        return (AccumT)this.delegate.mergeAccumulators(accumulators);
    }

    public OutputT extractOutput(AccumT accumulator) {
        return (OutputT)this.delegate.extractOutput(accumulator);
    }

    public AccumT compact(AccumT accumulator) {
        return (AccumT)this.delegate.compact(accumulator);
    }

    public OutputT apply(Iterable<? extends InputT> inputs) {
        return (OutputT)this.delegate.apply(inputs);
    }

    public OutputT defaultValue() {
        return (OutputT)this.delegate.defaultValue();
    }

    public Coder<AccumT> getAccumulatorCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
        return this.delegate.getAccumulatorCoder(registry, inputCoder);
    }

    public Coder<OutputT> getDefaultOutputCoder(CoderRegistry registry, Coder<InputT> inputCoder) throws CannotProvideCoderException {
        return this.delegate.getDefaultOutputCoder(registry, inputCoder);
    }

    public String getIncompatibleGlobalWindowErrorMessage() {
        return this.delegate.getIncompatibleGlobalWindowErrorMessage();
    }

    public TypeVariable<?> getInputTVariable() {
        return this.delegate.getInputTVariable();
    }

    public TypeVariable<?> getAccumTVariable() {
        return this.delegate.getAccumTVariable();
    }

    public TypeVariable<?> getOutputTVariable() {
        return this.delegate.getOutputTVariable();
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        this.delegate.populateDisplayData(builder);
    }

    @Nullable
    private <T> TypeDescriptor<T> getGenericSuperTypeAtIndex(int index) {
        Class superClass;
        Class cls = (Class)Preconditions.checkArgumentNotNull(((Object)((Object)this)).getClass());
        while ((superClass = cls.getSuperclass()) != null) {
            ParameterizedType superType;
            TypeDescriptor candidate;
            if (superClass.equals(TypedCombineFnDelegate.class) && !((candidate = TypeDescriptor.of((Type)(superType = (ParameterizedType)Preconditions.checkArgumentNotNull((Object)cls.getGenericSuperclass())).getActualTypeArguments()[index])) instanceof TypeVariable)) {
                return candidate;
            }
            cls = superClass;
        }
        return null;
    }
}

