/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.Pair;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

@Experimental
public class TestUnboundedTable
extends TestTable {
    private final List<Pair<Duration, List<Row>>> timestampedRows = new ArrayList<Pair<Duration, List<Row>>>();
    private int timestampField;
    private BeamTableStatistics statistics = BeamTableStatistics.UNBOUNDED_UNKNOWN;

    private TestUnboundedTable(Schema beamSchema) {
        super(beamSchema);
    }

    public static TestUnboundedTable of(Object ... args) {
        return new TestUnboundedTable(TestTableUtils.buildBeamSqlSchema(args));
    }

    public TestUnboundedTable setStatistics(BeamTableStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        return this.statistics;
    }

    public TestUnboundedTable timestampColumnIndex(int idx) {
        this.timestampField = idx;
        return this;
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    public TestUnboundedTable addRows(Duration duration, Object ... args) {
        List<Row> rows = TestTableUtils.buildRows(this.getSchema(), Arrays.asList(args));
        this.timestampedRows.add((Pair<Duration, List<Row>>)Pair.of((Object)duration, rows));
        return this;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        TestStream.Builder values = TestStream.create((Schema)this.schema);
        for (Pair<Duration, List<Row>> pair : this.timestampedRows) {
            values = values.advanceWatermarkTo(new Instant(0L).plus((ReadableDuration)pair.getKey()));
            for (int i = 0; i < ((List)pair.getValue()).size(); ++i) {
                values = values.addElements(TimestampedValue.of((Object)((Row)((List)pair.getValue()).get(i)), (Instant)new Instant((Object)((Row)((List)pair.getValue()).get(i)).getDateTime(this.timestampField))), new TimestampedValue[0]);
            }
        }
        return ((PCollection)begin.apply("MockedUnboundedTable_" + COUNTER.incrementAndGet(), (PTransform)values.advanceWatermarkToInfinity())).setRowSchema(this.getSchema());
    }
}

