/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.AutoValue_CovarianceAccumulator;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CovarianceFn;

@AutoValue
abstract class CovarianceAccumulator
implements Serializable {
    static final CovarianceAccumulator EMPTY = CovarianceAccumulator.newCovarianceAccumulator(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);

    CovarianceAccumulator() {
    }

    abstract BigDecimal covariance();

    abstract BigDecimal count();

    abstract BigDecimal xavg();

    abstract BigDecimal yavg();

    static CovarianceAccumulator newCovarianceAccumulator(BigDecimal covariance, BigDecimal count, BigDecimal xavg, BigDecimal yavg) {
        return new AutoValue_CovarianceAccumulator(covariance, count, xavg, yavg);
    }

    static CovarianceAccumulator ofZeroElements() {
        return EMPTY;
    }

    static CovarianceAccumulator ofSingleElement(BigDecimal inputElementX, BigDecimal inputElementY) {
        return CovarianceAccumulator.newCovarianceAccumulator(BigDecimal.ZERO, BigDecimal.ONE, inputElementX, inputElementY);
    }

    CovarianceAccumulator combineWith(CovarianceAccumulator otherCovariance) {
        if (EMPTY.equals(this)) {
            return otherCovariance;
        }
        if (EMPTY.equals(otherCovariance)) {
            return this;
        }
        BigDecimal increment = this.calculateIncrement(this, otherCovariance);
        BigDecimal combinedCovariance = this.covariance().add(otherCovariance.covariance()).add(increment);
        return CovarianceAccumulator.newCovarianceAccumulator(combinedCovariance, this.count().add(otherCovariance.count()), this.calculateXavg(this, otherCovariance), this.calculateYavg(this, otherCovariance));
    }

    private BigDecimal calculateIncrement(CovarianceAccumulator covarA, CovarianceAccumulator covarB) {
        BigDecimal countA = covarA.count();
        BigDecimal countB = covarB.count();
        BigDecimal totalCount = countA.add(countB);
        BigDecimal avgXA = covarA.xavg();
        BigDecimal avgYA = covarA.yavg();
        BigDecimal avgXB = covarB.xavg();
        BigDecimal avgYB = covarB.yavg();
        return avgXA.subtract(avgXB).multiply(avgYA.subtract(avgYB)).multiply(countA).multiply(countB).divide(totalCount, CovarianceFn.MATH_CTX);
    }

    private BigDecimal calculateXavg(CovarianceAccumulator covarA, CovarianceAccumulator covarB) {
        BigDecimal countA = covarA.count();
        BigDecimal countB = covarB.count();
        BigDecimal totalCount = countA.add(countB);
        BigDecimal avgXA = covarA.xavg();
        BigDecimal avgXB = covarB.xavg();
        return avgXA.multiply(countA).add(avgXB.multiply(countB)).divide(totalCount, CovarianceFn.MATH_CTX);
    }

    private BigDecimal calculateYavg(CovarianceAccumulator covarA, CovarianceAccumulator covarB) {
        BigDecimal countA = covarA.count();
        BigDecimal countB = covarB.count();
        BigDecimal totalCount = countA.add(countB);
        BigDecimal avgYA = covarA.yavg();
        BigDecimal avgYB = covarB.yavg();
        return avgYA.multiply(countA).add(avgYB.multiply(countB)).divide(totalCount, CovarianceFn.MATH_CTX);
    }
}

