/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.impl.SqlConversionException;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPCall;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexPatternFieldRef;

public abstract class CEPOperation
implements Serializable {
    public static CEPOperation of(RexNode operation) {
        if (operation.getClass() == RexCall.class) {
            RexCall call = (RexCall)operation;
            return CEPCall.of(call);
        }
        if (operation.getClass() == RexLiteral.class) {
            RexLiteral lit = (RexLiteral)operation;
            return CEPLiteral.of(lit);
        }
        if (operation.getClass() == RexPatternFieldRef.class) {
            RexPatternFieldRef fieldRef = (RexPatternFieldRef)operation;
            return CEPFieldRef.of(fieldRef);
        }
        throw new SqlConversionException("RexNode not supported: " + operation.getClass().getName());
    }
}

