/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql;

import java.util.Arrays;
import java.util.EnumSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public enum SqlFunctionCategory {
    STRING("STRING", "String function", Property.FUNCTION),
    NUMERIC("NUMERIC", "Numeric function", Property.FUNCTION),
    TIMEDATE("TIMEDATE", "Time and date function", Property.FUNCTION),
    SYSTEM("SYSTEM", "System function", Property.FUNCTION),
    USER_DEFINED_FUNCTION("UDF", "User-defined function", Property.USER_DEFINED, Property.FUNCTION),
    USER_DEFINED_PROCEDURE("UDP", "User-defined procedure", Property.USER_DEFINED),
    USER_DEFINED_CONSTRUCTOR("UDC", "User-defined constructor", Property.USER_DEFINED),
    USER_DEFINED_SPECIFIC_FUNCTION("UDF_SPECIFIC", "User-defined function with SPECIFIC name", Property.USER_DEFINED, Property.SPECIFIC, Property.FUNCTION),
    USER_DEFINED_TABLE_FUNCTION("TABLE_UDF", "User-defined table function", Property.USER_DEFINED, Property.TABLE_FUNCTION),
    USER_DEFINED_TABLE_SPECIFIC_FUNCTION("TABLE_UDF_SPECIFIC", "User-defined table function with SPECIFIC name", Property.USER_DEFINED, Property.TABLE_FUNCTION, Property.SPECIFIC),
    MATCH_RECOGNIZE("MATCH_RECOGNIZE", "MATCH_RECOGNIZE function", Property.TABLE_FUNCTION);

    private final EnumSet<Property> properties;

    private SqlFunctionCategory(String abbrev, String description, Property ... properties) {
        Util.discard(abbrev);
        Util.discard(description);
        this.properties = EnumSet.copyOf(Arrays.asList(properties));
    }

    public boolean isUserDefined() {
        return this.properties.contains((Object)Property.USER_DEFINED);
    }

    public boolean isTableFunction() {
        return this.properties.contains((Object)Property.TABLE_FUNCTION);
    }

    public boolean isFunction() {
        return this.properties.contains((Object)Property.FUNCTION);
    }

    public boolean isSpecific() {
        return this.properties.contains((Object)Property.SPECIFIC);
    }

    public boolean isUserDefinedNotSpecificFunction() {
        return this.isUserDefined() && (this.isFunction() || this.isTableFunction()) && !this.isSpecific();
    }

    static enum Property {
        USER_DEFINED,
        TABLE_FUNCTION,
        SPECIFIC,
        FUNCTION;

    }
}

