/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.BeamSqlRecordHelper;
import org.apache.beam.sdk.extensions.sql.BeamSqlSeekableTable;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Pair;

public class BeamJoinTransforms {
    private static BeamRecord combineTwoRowsIntoOne(BeamRecord leftRow, BeamRecord rightRow, boolean swap) {
        if (swap) {
            return BeamJoinTransforms.combineTwoRowsIntoOneHelper(rightRow, leftRow);
        }
        return BeamJoinTransforms.combineTwoRowsIntoOneHelper(leftRow, rightRow);
    }

    private static BeamRecord combineTwoRowsIntoOneHelper(BeamRecord leftRow, BeamRecord rightRow) {
        ArrayList<String> names = new ArrayList<String>(leftRow.getFieldCount() + rightRow.getFieldCount());
        names.addAll(leftRow.getDataType().getFieldNames());
        names.addAll(rightRow.getDataType().getFieldNames());
        ArrayList<Integer> types = new ArrayList<Integer>(leftRow.getFieldCount() + rightRow.getFieldCount());
        types.addAll(BeamSqlRecordHelper.getSqlRecordType(leftRow).getFieldTypes());
        types.addAll(BeamSqlRecordHelper.getSqlRecordType(rightRow).getFieldTypes());
        BeamRecordSqlType type = BeamRecordSqlType.create(names, types);
        ArrayList fieldValues = new ArrayList(leftRow.getDataValues());
        fieldValues.addAll(rightRow.getDataValues());
        return new BeamRecord((BeamRecordType)type, fieldValues);
    }

    public static class JoinAsLookup
    extends PTransform<PCollection<BeamRecord>, PCollection<BeamRecord>> {
        BeamSqlSeekableTable seekableTable;
        BeamRecordSqlType lkpRowType;
        BeamRecordSqlType joinSubsetType;
        List<Integer> factJoinIdx;

        public JoinAsLookup(RexNode joinCondition, BeamSqlSeekableTable seekableTable, BeamRecordSqlType lkpRowType, int factTableColSize) {
            this.seekableTable = seekableTable;
            this.lkpRowType = lkpRowType;
            this.joinFieldsMapping(joinCondition, factTableColSize);
        }

        private void joinFieldsMapping(RexNode joinCondition, int factTableColSize) {
            this.factJoinIdx = new ArrayList<Integer>();
            ArrayList<String> lkpJoinFieldsName = new ArrayList<String>();
            ArrayList<Integer> lkpJoinFieldsType = new ArrayList<Integer>();
            RexCall call = (RexCall)joinCondition;
            if ("AND".equals(call.getOperator().getName())) {
                List<RexNode> operands = call.getOperands();
                for (RexNode rexNode : operands) {
                    this.factJoinIdx.add(((RexInputRef)((RexCall)rexNode).getOperands().get(0)).getIndex());
                    int lkpJoinIdx = ((RexInputRef)((RexCall)rexNode).getOperands().get(1)).getIndex() - factTableColSize;
                    lkpJoinFieldsName.add(this.lkpRowType.getFieldNameByIndex(lkpJoinIdx));
                    lkpJoinFieldsType.add(this.lkpRowType.getFieldTypeByIndex(lkpJoinIdx));
                }
            } else if ("=".equals(call.getOperator().getName())) {
                this.factJoinIdx.add(((RexInputRef)call.getOperands().get(0)).getIndex());
                int lkpJoinIdx = ((RexInputRef)call.getOperands().get(1)).getIndex() - factTableColSize;
                lkpJoinFieldsName.add(this.lkpRowType.getFieldNameByIndex(lkpJoinIdx));
                lkpJoinFieldsType.add(this.lkpRowType.getFieldTypeByIndex(lkpJoinIdx));
            } else {
                throw new UnsupportedOperationException("Operator " + call.getOperator().getName() + " is not supported in join condition");
            }
            this.joinSubsetType = BeamRecordSqlType.create(lkpJoinFieldsName, lkpJoinFieldsType);
        }

        public PCollection<BeamRecord> expand(PCollection<BeamRecord> input) {
            return (PCollection)input.apply("join_as_lookup", (PTransform)ParDo.of((DoFn)new DoFn<BeamRecord, BeamRecord>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    BeamRecord factRow = (BeamRecord)context.element();
                    BeamRecord joinSubRow = this.extractJoinSubRow(factRow);
                    List<BeamRecord> lookupRows = seekableTable.seekRecord(joinSubRow);
                    for (BeamRecord lr : lookupRows) {
                        context.output((Object)BeamJoinTransforms.combineTwoRowsIntoOneHelper(factRow, lr));
                    }
                }

                private BeamRecord extractJoinSubRow(BeamRecord factRow) {
                    ArrayList<Object> joinSubsetValues = new ArrayList<Object>();
                    for (int i : factJoinIdx) {
                        joinSubsetValues.add(factRow.getFieldValue(i));
                    }
                    return new BeamRecord((BeamRecordType)joinSubsetType, joinSubsetValues);
                }
            }));
        }
    }

    public static class JoinParts2WholeRow
    extends SimpleFunction<KV<BeamRecord, KV<BeamRecord, BeamRecord>>, BeamRecord> {
        public BeamRecord apply(KV<BeamRecord, KV<BeamRecord, BeamRecord>> input) {
            KV parts = (KV)input.getValue();
            BeamRecord leftRow = (BeamRecord)parts.getKey();
            BeamRecord rightRow = (BeamRecord)parts.getValue();
            return BeamJoinTransforms.combineTwoRowsIntoOne(leftRow, rightRow, false);
        }
    }

    public static class SideInputJoinDoFn
    extends DoFn<KV<BeamRecord, BeamRecord>, BeamRecord> {
        private final PCollectionView<Map<BeamRecord, Iterable<BeamRecord>>> sideInputView;
        private final JoinRelType joinType;
        private final BeamRecord rightNullRow;
        private final boolean swap;

        public SideInputJoinDoFn(JoinRelType joinType, BeamRecord rightNullRow, PCollectionView<Map<BeamRecord, Iterable<BeamRecord>>> sideInputView, boolean swap) {
            this.joinType = joinType;
            this.rightNullRow = rightNullRow;
            this.sideInputView = sideInputView;
            this.swap = swap;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            BeamRecord key = (BeamRecord)((KV)context.element()).getKey();
            BeamRecord leftRow = (BeamRecord)((KV)context.element()).getValue();
            Map key2Rows = (Map)context.sideInput(this.sideInputView);
            Iterable rightRowsIterable = (Iterable)key2Rows.get(key);
            if (rightRowsIterable != null && rightRowsIterable.iterator().hasNext()) {
                for (BeamRecord aRightRowsIterable : rightRowsIterable) {
                    context.output((Object)BeamJoinTransforms.combineTwoRowsIntoOne(leftRow, aRightRowsIterable, this.swap));
                }
            } else if (this.joinType == JoinRelType.LEFT) {
                context.output((Object)BeamJoinTransforms.combineTwoRowsIntoOne(leftRow, this.rightNullRow, this.swap));
            }
        }
    }

    public static class ExtractJoinFields
    extends SimpleFunction<BeamRecord, KV<BeamRecord, BeamRecord>> {
        private final boolean isLeft;
        private final List<Pair<Integer, Integer>> joinColumns;

        public ExtractJoinFields(boolean isLeft, List<Pair<Integer, Integer>> joinColumns) {
            this.isLeft = isLeft;
            this.joinColumns = joinColumns;
        }

        public KV<BeamRecord, BeamRecord> apply(BeamRecord input) {
            ArrayList<String> names = new ArrayList<String>(this.joinColumns.size());
            ArrayList<Integer> types = new ArrayList<Integer>(this.joinColumns.size());
            for (int i = 0; i < this.joinColumns.size(); ++i) {
                names.add("c" + i);
                types.add(this.isLeft ? BeamSqlRecordHelper.getSqlRecordType(input).getFieldTypeByIndex(this.joinColumns.get(i).getKey()) : BeamSqlRecordHelper.getSqlRecordType(input).getFieldTypeByIndex(this.joinColumns.get(i).getValue()));
            }
            BeamRecordSqlType type = BeamRecordSqlType.create(names, types);
            ArrayList<Object> fieldValues = new ArrayList<Object>(this.joinColumns.size());
            for (Pair<Integer, Integer> joinColumn : this.joinColumns) {
                fieldValues.add(input.getFieldValue(this.isLeft ? joinColumn.getKey().intValue() : joinColumn.getValue().intValue()));
            }
            return KV.of((Object)new BeamRecord((BeamRecordType)type, fieldValues), (Object)input);
        }
    }
}

