/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URI;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.parser.ColumnDefinition;
import org.apache.beam.sdk.extensions.sql.impl.parser.UnparseUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Strings;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.ImmutableNullableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.NlsString;

public class SqlCreateTable
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_TABLE", SqlKind.OTHER){

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... o) {
            assert (functionQualifier == null);
            return new SqlCreateTable(pos, (SqlIdentifier)o[0], (SqlNodeList)o[1], o[2], o[3], o[4], o[5], o[6]);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlCreateTable t = (SqlCreateTable)call;
            UnparseUtil u = new UnparseUtil(writer, leftPrec, rightPrec);
            u.keyword("CREATE", "TABLE").node(t.tblName).nodeList(t.fieldList);
            u.keyword("TYPE").node(t.type);
            u.keyword("COMMENT").node(t.comment);
            u.keyword("LOCATION").node(t.location);
            if (t.properties != null) {
                u.keyword("TBLPROPERTIES").node(t.properties);
            }
            if (t.query != null) {
                u.keyword("AS").node(t.query);
            }
        }
    };
    private final SqlIdentifier tblName;
    private final SqlNodeList fieldList;
    private final SqlNode type;
    private final SqlNode comment;
    private final SqlNode location;
    private final SqlNode properties;
    private final SqlNode query;

    public SqlCreateTable(SqlParserPos pos, SqlIdentifier tblName, SqlNodeList fieldList, SqlNode type, SqlNode comment, SqlNode location, SqlNode properties, SqlNode query) {
        super(pos);
        this.tblName = tblName;
        this.fieldList = fieldList;
        this.type = type;
        this.comment = comment;
        this.location = location;
        this.properties = properties;
        this.query = query;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.getOperator().unparse(writer, this, leftPrec, rightPrec);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tblName, this.fieldList, this.location, this.properties, this.query);
    }

    public String tableName() {
        return this.tblName.toString();
    }

    public URI location() {
        return this.location == null ? null : URI.create(this.getString(this.location));
    }

    public String type() {
        return this.type == null ? null : this.getString(this.type);
    }

    public String comment() {
        return this.comment == null ? null : this.getString(this.comment);
    }

    public JSONObject properties() {
        String propertiesStr = this.getString(this.properties);
        if (Strings.isNullOrEmpty(propertiesStr)) {
            return new JSONObject();
        }
        return JSON.parseObject((String)propertiesStr);
    }

    private String getString(SqlNode n) {
        return n == null ? null : ((NlsString)SqlLiteral.value(n)).getValue();
    }

    public List<ColumnDefinition> fieldList() {
        return this.fieldList.getList();
    }
}

