/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Function;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class ReinterpretConversion {
    private Set<SqlTypeName> from;
    private SqlTypeName to;
    private Function<BeamSqlPrimitive, BeamSqlPrimitive> convertFunction;

    private ReinterpretConversion(Builder builder) {
        this.from = ImmutableSet.copyOf(builder.from);
        this.to = builder.to;
        this.convertFunction = builder.convert;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BeamSqlPrimitive convert(BeamSqlPrimitive input) {
        if (!this.from.contains((Object)input.getOutputType())) {
            throw new IllegalArgumentException("Unable to convert from " + input.getOutputType().name() + " to " + this.to.name() + ". This conversion only supports " + this.toString());
        }
        return this.convertFunction.apply(input);
    }

    public SqlTypeName to() {
        return this.to;
    }

    public Set<SqlTypeName> from() {
        return this.from;
    }

    public String toString() {
        return this.from.toString() + "->" + this.to.name();
    }

    public static class Builder {
        private Set<SqlTypeName> from = new HashSet<SqlTypeName>();
        private SqlTypeName to;
        private Function<BeamSqlPrimitive, BeamSqlPrimitive> convert;

        public Builder from(SqlTypeName from) {
            this.from.add(from);
            return this;
        }

        public Builder from(Collection<SqlTypeName> from) {
            this.from.addAll(from);
            return this;
        }

        public Builder from(SqlTypeName ... from) {
            return this.from(Arrays.asList(from));
        }

        public Builder to(SqlTypeName to) {
            this.to = to;
            return this;
        }

        public Builder convert(Function<BeamSqlPrimitive, BeamSqlPrimitive> convert) {
            this.convert = convert;
            return this;
        }

        public ReinterpretConversion build() {
            if (this.from.isEmpty() || this.to == null || this.convert == null) {
                throw new IllegalArgumentException("All arguments to ReinterpretConversion.Builder are mandatory.");
            }
            return new ReinterpretConversion(this);
        }
    }
}

