/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math;

import java.util.List;
import java.util.Random;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlRandIntegerExpression
extends BeamSqlExpression {
    private Random rand = new Random();
    private Integer seed = null;

    public BeamSqlRandIntegerExpression(List<BeamSqlExpression> subExps) {
        super(subExps, SqlTypeName.INTEGER);
    }

    @Override
    public boolean accept() {
        return true;
    }

    @Override
    public BeamSqlPrimitive evaluate(BeamRecord inputRecord, BoundedWindow window) {
        int numericIdx = 0;
        if (this.operands.size() == 2) {
            int rowSeed = (Integer)this.opValueEvaluated(0, inputRecord, window);
            if (this.seed == null || this.seed != rowSeed) {
                this.rand.setSeed(rowSeed);
            }
            numericIdx = 1;
        }
        return BeamSqlPrimitive.of(SqlTypeName.INTEGER, this.rand.nextInt((Integer)this.opValueEvaluated(numericIdx, inputRecord, window)));
    }
}

