/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class InMemoryMetaStore
implements MetaStore {
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> tables = new HashMap<String, Table>();
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> providers = new HashMap<String, TableProvider>();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "store";
    }

    @Override
    public void createTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        this.validateTableType(table);
        if (this.tables.containsKey(table.getName())) {
            throw new IllegalArgumentException("Duplicate table name: " + table.getName());
        }
        this.providers.get(table.getType()).createTable(table);
        this.tables.put(table.getName(), table);
    }

    @Override
    public void dropTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        if (!this.tables.containsKey(tableName)) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        Table table = this.tables.get(tableName);
        this.providers.get(table.getType()).dropTable(tableName);
        this.tables.remove(tableName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> getTables() {
        return ImmutableMap.copyOf(this.tables);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        TableProvider provider = this.providers.get(table.getType());
        return provider.buildBeamSqlTable(table);
    }

    private void validateTableType(@UnknownKeyFor @NonNull @Initialized Table table) {
        if (!this.providers.containsKey(table.getType())) {
            throw new IllegalArgumentException("Table type: " + table.getType() + " not supported!");
        }
    }

    @Override
    public void registerProvider(@UnknownKeyFor @NonNull @Initialized TableProvider provider) {
        if (this.providers.containsKey(provider.getTableType())) {
            throw new IllegalArgumentException("Provider is already registered for table type: " + provider.getTableType());
        }
        this.initTablesFromProvider(provider);
        this.providers.put(provider.getTableType(), provider);
    }

    private void initTablesFromProvider(@UnknownKeyFor @NonNull @Initialized TableProvider provider) {
        Map<String, Table> tables = provider.getTables();
        for (String tableName : tables.keySet()) {
            if (!this.tables.containsKey(tableName)) continue;
            throw new IllegalStateException("Duplicate table: " + tableName + " from provider: " + provider);
        }
        this.tables.putAll(tables);
    }

    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> getProviders() {
        return this.providers;
    }
}

