/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaAvroTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaCSVTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaJsonTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaProtoTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaThriftTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.thrift.protocol.TProtocolFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KafkaTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        Schema schema = table.getSchema();
        JSONObject properties = table.getProperties();
        String bootstrapServers = properties.getString("bootstrap.servers");
        JSONArray topicsArr = properties.getJSONArray("topics");
        ArrayList<String> topics = new ArrayList<String>(topicsArr.size());
        for (Object topic : topicsArr) {
            topics.add(topic.toString());
        }
        PayloadFormat payloadFormat = properties.containsKey((Object)"format") ? PayloadFormat.valueOf(properties.getString("format").toUpperCase()) : PayloadFormat.CSV;
        switch (payloadFormat) {
            case CSV: {
                return new BeamKafkaCSVTable(schema, bootstrapServers, topics);
            }
            case AVRO: {
                return new BeamKafkaAvroTable(schema, bootstrapServers, topics);
            }
            case JSON: {
                return new BeamKafkaJsonTable(schema, bootstrapServers, topics);
            }
            case PROTO: {
                return this.protoTable(schema, bootstrapServers, topics, properties);
            }
            case THRIFT: {
                return this.thriftTable(schema, bootstrapServers, topics, properties);
            }
        }
        throw new IllegalArgumentException("Unsupported payload format: " + (Object)((Object)payloadFormat));
    }

    private @UnknownKeyFor @NonNull @Initialized BeamKafkaProtoTable protoTable(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized String bootstrapServers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> topics, @UnknownKeyFor @NonNull @Initialized JSONObject properties) {
        String protoClassName = properties.getString("protoClass");
        try {
            Class<?> protoClass = Class.forName(protoClassName);
            return new BeamKafkaProtoTable(schema, bootstrapServers, topics, protoClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Incorrect proto class provided: " + protoClassName);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized BeamKafkaThriftTable thriftTable(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized String bootstrapServers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> topics, @UnknownKeyFor @NonNull @Initialized JSONObject properties) {
        String thriftClassName = properties.getString("thriftClass");
        String thriftProtocolFactoryClassName = properties.getString("thriftProtocolFactoryClass");
        try {
            TProtocolFactory thriftProtocolFactory;
            Class<?> thriftClass = Class.forName(thriftClassName);
            try {
                Class<?> thriftProtocolFactoryClass = Class.forName(thriftProtocolFactoryClassName);
                thriftProtocolFactory = (TProtocolFactory)thriftProtocolFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Incorrect thrift protocol factory class provided: " + thriftProtocolFactoryClassName);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Could not instantiate the thrift protocol factory class", e);
            }
            return new BeamKafkaThriftTable(schema, bootstrapServers, topics, thriftClass, thriftProtocolFactory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Incorrect thrift class provided: " + thriftClassName);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "kafka";
    }

    private static enum PayloadFormat {
        CSV,
        AVRO,
        JSON,
        PROTO,
        THRIFT;

    }
}

