/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.io.thrift.ThriftCoder;
import org.apache.beam.sdk.io.thrift.ThriftSchema;
import org.apache.beam.sdk.schemas.RowMessages;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.protocol.TProtocolFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamKafkaThriftTable<@UnknownKeyFor FieldT extends @UnknownKeyFor @NonNull @Initialized TFieldIdEnum, @UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized TBase<T, FieldT>>
extends BeamKafkaTable {
    private static final @UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider = ThriftSchema.provider();
    private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

    public BeamKafkaThriftTable(@UnknownKeyFor @NonNull @Initialized Schema requiredSchema, @UnknownKeyFor @NonNull @Initialized String bootstrapServers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> topics, @UnknownKeyFor @NonNull @Initialized Class<T> thriftClass, @UnknownKeyFor @NonNull @Initialized TProtocolFactory protocolFactory) {
        super(BeamKafkaThriftTable.thriftSchema(thriftClass, requiredSchema), bootstrapServers, topics);
        this.typeDescriptor = TypeDescriptor.of(thriftClass);
        this.coder = ThriftCoder.of(thriftClass, (TProtocolFactory)protocolFactory);
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema thriftSchema(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> thriftClass, @UnknownKeyFor @NonNull @Initialized Schema requiredSchema) {
        TypeDescriptor typeDescriptor = TypeDescriptor.of(thriftClass);
        Schema schema = (Schema)Preconditions.checkArgumentNotNull((Object)schemaProvider.schemaFor(typeDescriptor));
        if (!schema.assignableTo(requiredSchema)) {
            throw new IllegalArgumentException(String.format("Given message schema: '%s'%ndoes not match schema inferred from thrift class.%nThrift class: '%s'%nInferred schema: '%s'", requiredSchema, thriftClass.getName(), schema));
        }
        return schema;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> getPTransformForInput() {
        return new InputTransformer<T>(this.schema, this.typeDescriptor, this.coder);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>> getPTransformForOutput() {
        return new OutputTransformer<T>(this.typeDescriptor, this.coder);
    }

    private static class OutputTransformer<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized TBase<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>
    extends PTransform<PCollection<Row>, PCollection<KV<byte[], byte[]>>> {
        private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> binTypeDescriptor = TypeDescriptor.of(byte[].class);
        private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] emptyKey = new byte[0];
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> fromRowFn;

        OutputTransformer(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.fromRowFn = RowMessages.rowToBytesFn((SchemaProvider)schemaProvider, typeDescriptor, coder);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            return (PCollection)((PCollection)input.apply("row-to-thrift-bytes", (PTransform)MapElements.via(this.fromRowFn))).apply("bytes-to-kvs", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.kvs(binTypeDescriptor, binTypeDescriptor)).via((SerializableFunction & Serializable)bytes -> KV.of((Object)emptyKey, (Object)bytes)));
        }
    }

    private static class InputTransformer<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized TBase<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>
    extends PTransform<PCollection<KV<byte[], byte[]>>, PCollection<Row>> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> toRowFn;

        InputTransformer(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            this.schema = schema;
            this.toRowFn = RowMessages.bytesToRowFn((SchemaProvider)schemaProvider, typeDescriptor, coder);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> input) {
            return ((PCollection)((PCollection)input.apply("drop-kafka-keys", (PTransform)Values.create())).apply("thrift-to-row", (PTransform)MapElements.via(this.toRowFn))).setRowSchema(this.schema);
        }
    }
}

