/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamPushDownIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.TableScan;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamIOSourceRel
extends TableScan
implements BeamRelNode {
    public static final @UnknownKeyFor @NonNull @Initialized double CONSTANT_WINDOW_SIZE = 10.0;
    private final @UnknownKeyFor @NonNull @Initialized BeamSqlTable beamTable;
    private final @UnknownKeyFor @NonNull @Initialized BeamCalciteTable calciteTable;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptions;

    public BeamIOSourceRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelOptTable table, @UnknownKeyFor @NonNull @Initialized BeamSqlTable beamTable, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptions, @UnknownKeyFor @NonNull @Initialized BeamCalciteTable calciteTable) {
        super(cluster, traitSet, table);
        this.beamTable = beamTable;
        this.calciteTable = calciteTable;
        this.pipelineOptions = pipelineOptions;
    }

    public @UnknownKeyFor @NonNull @Initialized BeamPushDownIOSourceRel createPushDownRel(@UnknownKeyFor @NonNull @Initialized RelDataType newType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> usedFields, @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter tableFilters) {
        RelOptTable relOptTable = newType == null ? this.table : ((RelOptTableImpl)this.getTable()).copy(newType);
        return new BeamPushDownIOSourceRel(this.getCluster(), this.traitSet, relOptTable, this.beamTable, usedFields, tableFilters, this.pipelineOptions, this.calciteTable);
    }

    public @UnknownKeyFor @NonNull @Initialized double estimateRowCount(@UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        BeamTableStatistics rowCountStatistics = this.calciteTable.getStatistic();
        if (this.beamTable.isBounded() == PCollection.IsBounded.BOUNDED) {
            return rowCountStatistics.getRowCount();
        }
        return rowCountStatistics.getRate();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        BeamTableStatistics rowCountStatistics = this.calciteTable.getStatistic();
        double window = this.beamTable.isBounded() == PCollection.IsBounded.BOUNDED ? rowCountStatistics.getRowCount() : 10.0;
        return NodeStats.create(rowCountStatistics.getRowCount(), rowCountStatistics.getRate(), window);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return this.beamTable.isBounded();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    public @UnknownKeyFor @NonNull @Initialized RelOptCost computeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        double rowCount = this.estimateRowCount(mq);
        return planner.getCostFactory().makeCost(rowCount, rowCount, rowCount);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats(this, mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable getBeamSqlTable() {
        return this.beamTable;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getPipelineOptions() {
        return this.pipelineOptions;
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> input) {
            Preconditions.checkArgument((input.size() == 0 ? 1 : 0) != 0, (String)"Should not have received input for %s: %s", (Object[])new Object[]{BeamIOSourceRel.class.getSimpleName(), input});
            return BeamIOSourceRel.this.beamTable.buildIOReader(input.getPipeline().begin());
        }
    }
}

