/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamBuiltinAggregations;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamBuiltinAnalyticFunctions {
    public static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Function<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> BUILTIN_ANALYTIC_FACTORIES = ImmutableMap.builder().putAll(BeamBuiltinAggregations.BUILTIN_AGGREGATOR_FACTORIES).put((Object)"FIRST_VALUE", typeName -> BeamBuiltinAnalyticFunctions.navigationFirstValue()).put((Object)"LAST_VALUE", typeName -> BeamBuiltinAnalyticFunctions.navigationLastValue()).put((Object)"ROW_NUMBER", typeName -> BeamBuiltinAnalyticFunctions.numberingRowNumber()).put((Object)"DENSE_RANK", typeName -> BeamBuiltinAnalyticFunctions.numberingDenseRank()).put((Object)"RANK", typeName -> BeamBuiltinAnalyticFunctions.numberingRank()).put((Object)"PERCENT_RANK", typeName -> BeamBuiltinAnalyticFunctions.numberingPercentRank()).build();

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> create(@UnknownKeyFor @NonNull @Initialized String functionName, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>> aggregatorFactory = BUILTIN_ANALYTIC_FACTORIES.get(functionName);
        if (aggregatorFactory != null) {
            return aggregatorFactory.apply(fieldType);
        }
        throw new UnsupportedOperationException(String.format("Analytics Function [%s] is not supported", functionName));
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> navigationFirstValue() {
        return new FirstValueCombineFn();
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> navigationLastValue() {
        return new LastValueCombineFn();
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> numberingRowNumber() {
        return new RowNumberCombineFn();
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> numberingDenseRank() {
        return new DenseRankCombineFn();
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> numberingRank() {
        return new RankCombineFn();
    }

    public static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, T> numberingPercentRank() {
        return new PercentRankCombineFn();
    }

    private static class PercentRankCombineFn<@UnknownKeyFor T>
    extends PositionAwareCombineFn<BigDecimal, KV<Optional<Long>, KV<BigDecimal, Long>>, Double> {
        @UnknownKeyFor @NonNull @Initialized RankCombineFn internalRank = new RankCombineFn();

        PercentRankCombineFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long>> addInput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long>> accumulator, @UnknownKeyFor @NonNull @Initialized BigDecimal input, @UnknownKeyFor @NonNull @Initialized Long cursorPosition, @UnknownKeyFor @NonNull @Initialized Long cursorPartition, @UnknownKeyFor @NonNull @Initialized Long countPartition) {
            KV<BigDecimal, Long> ac1 = this.internalRank.addInput((KV<BigDecimal, Long>)((KV)accumulator.getValue()), input, cursorPosition, cursorPartition, countPartition);
            Optional<Long> ac2 = Optional.of(countPartition);
            return KV.of(ac2, ac1);
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long>> createAccumulator() {
            return KV.of(Optional.empty(), this.internalRank.createAccumulator());
        }

        public @UnknownKeyFor @NonNull @Initialized Double extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long>> accumulator) {
            Long nr = ((Optional)accumulator.getKey()).orElse(null);
            Long rk = this.internalRank.extractOutput((KV<BigDecimal, Long>)((KV)accumulator.getValue()));
            Double r = 0.0;
            if (nr != null && rk != null && nr > 1L) {
                r = (rk.doubleValue() - 1.0) / (nr.doubleValue() - 1.0);
            }
            return r;
        }
    }

    private static class RankCombineFn<@UnknownKeyFor T>
    extends PositionAwareCombineFn<BigDecimal, KV<BigDecimal, Long>, Long> {
        private RankCombineFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long> addInput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long> accumulator, @UnknownKeyFor @NonNull @Initialized BigDecimal input, @UnknownKeyFor @NonNull @Initialized Long cursorPosition, @UnknownKeyFor @NonNull @Initialized Long cursorPartition, @UnknownKeyFor @NonNull @Initialized Long countPartition) {
            KV r = null;
            r = accumulator == null ? KV.of((Object)input, (Object)0L) : (((BigDecimal)accumulator.getKey()).compareTo(input) == 0 ? KV.of((Object)input, (Object)((Long)accumulator.getValue())) : KV.of((Object)input, (Object)cursorPosition));
            return r;
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long> createAccumulator() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long> accumulator) {
            return accumulator != null ? Long.valueOf((Long)accumulator.getValue() + 1L) : null;
        }
    }

    private static class DenseRankCombineFn<@UnknownKeyFor T>
    extends PositionAwareCombineFn<BigDecimal, KV<BigDecimal, Long>, Long> {
        private DenseRankCombineFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long> addInput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long> accumulator, @UnknownKeyFor @NonNull @Initialized BigDecimal input, @UnknownKeyFor @NonNull @Initialized Long cursorPosition, @UnknownKeyFor @NonNull @Initialized Long cursorPartition, @UnknownKeyFor @NonNull @Initialized Long countPartition) {
            KV r = null;
            r = accumulator == null ? KV.of((Object)input, (Object)0L) : (((BigDecimal)accumulator.getKey()).compareTo(input) == 0 ? KV.of((Object)input, (Object)((Long)accumulator.getValue())) : KV.of((Object)input, (Object)((Long)accumulator.getValue() + 1L)));
            return r;
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long> createAccumulator() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized BigDecimal, @UnknownKeyFor @NonNull @Initialized Long> accumulator) {
            return accumulator != null ? Long.valueOf((Long)accumulator.getValue() + 1L) : null;
        }
    }

    private static class RowNumberCombineFn<@UnknownKeyFor T>
    extends PositionAwareCombineFn<BigDecimal, Optional<Long>, Long> {
        private RowNumberCombineFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long> addInput(@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long> accumulator, @UnknownKeyFor @NonNull @Initialized BigDecimal input, @UnknownKeyFor @NonNull @Initialized Long cursorPosition, @UnknownKeyFor @NonNull @Initialized Long cursorPartition, @UnknownKeyFor @NonNull @Initialized Long countPartition) {
            return Optional.of(cursorPartition);
        }

        public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long> createAccumulator() {
            return Optional.empty();
        }

        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Long> accumulator) {
            return accumulator.isPresent() ? Long.valueOf(accumulator.get() + 1L) : null;
        }
    }

    public static abstract class PositionAwareCombineFn<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends Combine.CombineFn<InputT, AccumT, OutputT> {
        public abstract AccumT addInput(AccumT var1, InputT var2, @UnknownKeyFor @NonNull @Initialized Long var3, @UnknownKeyFor @NonNull @Initialized Long var4, @UnknownKeyFor @NonNull @Initialized Long var5);

        public AccumT addInput(AccumT mutableAccumulator, InputT input) {
            throw new UnsupportedOperationException();
        }

        public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            throw new UnsupportedOperationException();
        }
    }

    private static class LastValueCombineFn<@UnknownKeyFor T>
    extends Combine.CombineFn<T, Optional<T>, T> {
        private LastValueCombineFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized Optional<T> createAccumulator() {
            return Optional.empty();
        }

        public @UnknownKeyFor @NonNull @Initialized Optional<T> addInput(@UnknownKeyFor @NonNull @Initialized Optional<T> accumulator, T input) {
            Optional<T> r = Optional.of(input);
            return r;
        }

        public @UnknownKeyFor @NonNull @Initialized Optional<T> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Optional<T>> accumulators) {
            throw new UnsupportedOperationException();
        }

        public T extractOutput(@UnknownKeyFor @NonNull @Initialized Optional<T> accumulator) {
            return accumulator.isPresent() ? (T)accumulator.get() : null;
        }
    }

    private static class FirstValueCombineFn<@UnknownKeyFor T>
    extends Combine.CombineFn<T, Optional<T>, T> {
        private FirstValueCombineFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized Optional<T> createAccumulator() {
            return Optional.empty();
        }

        public @UnknownKeyFor @NonNull @Initialized Optional<T> addInput(@UnknownKeyFor @NonNull @Initialized Optional<T> accumulator, T input) {
            Optional<T> r = accumulator;
            if (!accumulator.isPresent()) {
                r = Optional.of(input);
            }
            return r;
        }

        public @UnknownKeyFor @NonNull @Initialized Optional<T> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Optional<T>> accumulators) {
            throw new UnsupportedOperationException();
        }

        public T extractOutput(@UnknownKeyFor @NonNull @Initialized Optional<T> accumulator) {
            return accumulator.isPresent() ? (T)accumulator.get() : null;
        }
    }
}

