/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CovarianceFn;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceFn;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sample;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamBuiltinAggregations {
    public static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Function<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> BUILTIN_AGGREGATOR_FACTORIES = ImmutableMap.builder().put((Object)"ANY_VALUE", typeName -> Sample.anyValueCombineFn()).put((Object)"COUNT", typeName -> Count.combineFn()).put((Object)"MAX", BeamBuiltinAggregations::createMax).put((Object)"MIN", BeamBuiltinAggregations::createMin).put((Object)"SUM", BeamBuiltinAggregations::createSum).put((Object)"$SUM0", BeamBuiltinAggregations::createSum).put((Object)"AVG", BeamBuiltinAggregations::createAvg).put((Object)"BIT_OR", BeamBuiltinAggregations::createBitOr).put((Object)"BIT_AND", BeamBuiltinAggregations::createBitAnd).put((Object)"VAR_POP", t -> VarianceFn.newPopulation(t.getTypeName())).put((Object)"VAR_SAMP", t -> VarianceFn.newSample(t.getTypeName())).put((Object)"COVAR_POP", t -> CovarianceFn.newPopulation(t.getTypeName())).put((Object)"COVAR_SAMP", t -> CovarianceFn.newSample(t.getTypeName())).build();
    private static @UnknownKeyFor @NonNull @Initialized MathContext mc = new MathContext(10, RoundingMode.HALF_UP);

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> create(@UnknownKeyFor @NonNull @Initialized String functionName, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>> aggregatorFactory = BUILTIN_AGGREGATOR_FACTORIES.get(functionName);
        if (aggregatorFactory != null) {
            return aggregatorFactory.apply(fieldType);
        }
        throw new UnsupportedOperationException(String.format("Aggregator [%s] is not supported", functionName));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createMax(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (CalciteUtils.isDateTimeType(fieldType)) {
            return new CustMax();
        }
        switch (fieldType.getTypeName()) {
            case BOOLEAN: 
            case INT16: 
            case BYTE: 
            case FLOAT: 
            case DATETIME: 
            case DECIMAL: 
            case STRING: {
                return new CustMax();
            }
            case INT32: {
                return Max.ofIntegers();
            }
            case INT64: {
                return Max.ofLongs();
            }
            case DOUBLE: {
                return Max.ofDoubles();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in MAX", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createMin(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (CalciteUtils.isDateTimeType(fieldType)) {
            return new CustMin();
        }
        switch (fieldType.getTypeName()) {
            case BOOLEAN: 
            case INT16: 
            case BYTE: 
            case FLOAT: 
            case DATETIME: 
            case DECIMAL: 
            case STRING: {
                return new CustMin();
            }
            case INT32: {
                return Min.ofIntegers();
            }
            case INT64: {
                return Min.ofLongs();
            }
            case DOUBLE: {
                return Min.ofDoubles();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in MIN", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createSum(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return Sum.ofIntegers();
            }
            case INT16: {
                return new ShortSum();
            }
            case BYTE: {
                return new ByteSum();
            }
            case INT64: {
                return Sum.ofLongs();
            }
            case FLOAT: {
                return new FloatSum();
            }
            case DOUBLE: {
                return Sum.ofDoubles();
            }
            case DECIMAL: {
                return new BigDecimalSum();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in SUM", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createAvg(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return new IntegerAvg();
            }
            case INT16: {
                return new ShortAvg();
            }
            case BYTE: {
                return new ByteAvg();
            }
            case INT64: {
                return new LongAvg();
            }
            case FLOAT: {
                return new FloatAvg();
            }
            case DOUBLE: {
                return new DoubleAvg();
            }
            case DECIMAL: {
                return new BigDecimalAvg();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in AVG", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createBitOr(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.INT64) {
            return new BitOr();
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in BIT_OR", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createBitAnd(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.INT64) {
            return new BitAnd();
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in BIT_AND", fieldType));
    }

    static class BitAnd<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
    extends Combine.CombineFn<T, Long, Long> {
        private @UnknownKeyFor @NonNull @Initialized boolean isEmpty = true;

        BitAnd() {
        }

        public @UnknownKeyFor @NonNull @Initialized Long createAccumulator() {
            return -1L;
        }

        public @UnknownKeyFor @NonNull @Initialized Long addInput(@UnknownKeyFor @NonNull @Initialized Long accum, T input) {
            if (input != null) {
                this.isEmpty = false;
                return accum & ((Number)input).longValue();
            }
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized Long mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Long> accums) {
            Long merged = this.createAccumulator();
            for (Long accum : accums) {
                merged = merged & accum;
            }
            return merged;
        }

        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized Long accum) {
            if (this.isEmpty) {
                return null;
            }
            return accum;
        }
    }

    static class BitOr<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
    extends Combine.CombineFn<T, Long, Long> {
        BitOr() {
        }

        public @UnknownKeyFor @NonNull @Initialized Long createAccumulator() {
            return 0L;
        }

        public @UnknownKeyFor @NonNull @Initialized Long addInput(@UnknownKeyFor @NonNull @Initialized Long accum, T input) {
            return accum | ((Number)input).longValue();
        }

        public @UnknownKeyFor @NonNull @Initialized Long mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Long> accums) {
            Long merged = this.createAccumulator();
            for (Long accum : accums) {
                merged = merged | accum;
            }
            return merged;
        }

        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized Long accum) {
            return accum;
        }
    }

    static class BigDecimalAvg
    extends Avg<BigDecimal> {
        BigDecimalAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized BigDecimal extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : this.prepareOutput(accumulator);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized BigDecimal record) {
            return record;
        }
    }

    static class DoubleAvg
    extends Avg<Double> {
        DoubleAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Double extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Double.valueOf(this.prepareOutput(accumulator).doubleValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Double record) {
            return new BigDecimal(record);
        }
    }

    static class FloatAvg
    extends Avg<Float> {
        FloatAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Float extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Float.valueOf(this.prepareOutput(accumulator).floatValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Float record) {
            return new BigDecimal(record.floatValue());
        }
    }

    static class ByteAvg
    extends Avg<Byte> {
        ByteAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Byte extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Byte.valueOf(this.prepareOutput(accumulator).byteValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Byte record) {
            return new BigDecimal(record.byteValue());
        }
    }

    static class ShortAvg
    extends Avg<Short> {
        ShortAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Short extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Short.valueOf(this.prepareOutput(accumulator).shortValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Short record) {
            return new BigDecimal(record.shortValue());
        }
    }

    static class LongAvg
    extends Avg<Long> {
        LongAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Long.valueOf(this.prepareOutput(accumulator).longValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Long record) {
            return new BigDecimal(record);
        }
    }

    static class IntegerAvg
    extends Avg<Integer> {
        IntegerAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Integer extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Integer.valueOf(this.prepareOutput(accumulator).intValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Integer record) {
            return new BigDecimal(record);
        }
    }

    static abstract class Avg<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
    extends Combine.CombineFn<T, KV<Integer, BigDecimal>, T> {
        Avg() {
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> createAccumulator() {
            return KV.of((Object)0, (Object)BigDecimal.ZERO);
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> addInput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator, T input) {
            return KV.of((Object)((Integer)accumulator.getKey() + 1), (Object)((BigDecimal)accumulator.getValue()).add(this.toBigDecimal(input)));
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal>> accumulators) {
            int size = 0;
            BigDecimal acc = BigDecimal.ZERO;
            for (KV<Integer, BigDecimal> ele : accumulators) {
                size += ((Integer)ele.getKey()).intValue();
                acc = acc.add((BigDecimal)ele.getValue());
            }
            return KV.of((Object)size, (Object)acc);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
            return KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)BigDecimalCoder.of());
        }

        protected @UnknownKeyFor @NonNull @Initialized BigDecimal prepareOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return ((BigDecimal)accumulator.getValue()).divide(new BigDecimal((Integer)accumulator.getKey()), mc);
        }

        public abstract T extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(T var1);
    }

    static class BigDecimalSum
    extends Combine.BinaryCombineFn<BigDecimal> {
        BigDecimalSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized BigDecimal apply(@UnknownKeyFor @NonNull @Initialized BigDecimal left, @UnknownKeyFor @NonNull @Initialized BigDecimal right) {
            return left.add(right);
        }
    }

    static class FloatSum
    extends Combine.BinaryCombineFn<Float> {
        FloatSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Float apply(@UnknownKeyFor @NonNull @Initialized Float left, @UnknownKeyFor @NonNull @Initialized Float right) {
            return Float.valueOf(left.floatValue() + right.floatValue());
        }
    }

    static class ByteSum
    extends Combine.BinaryCombineFn<Byte> {
        ByteSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Byte apply(@UnknownKeyFor @NonNull @Initialized Byte left, @UnknownKeyFor @NonNull @Initialized Byte right) {
            return (byte)(left + right);
        }
    }

    static class ShortSum
    extends Combine.BinaryCombineFn<Short> {
        ShortSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Short apply(@UnknownKeyFor @NonNull @Initialized Short left, @UnknownKeyFor @NonNull @Initialized Short right) {
            return (short)(left + right);
        }
    }

    static class CustMin<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMin() {
        }

        public T apply(T left, T right) {
            return left == null || left.compareTo(right) < 0 ? left : right;
        }
    }

    static class CustMax<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMax() {
        }

        public T apply(T left, T right) {
            return right == null || right.compareTo(left) < 0 ? left : right;
        }
    }
}

