/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider;

import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;

public class ReadOnlyTableProvider
implements TableProvider {
    private final String typeName;
    private final Map<String, BeamSqlTable> tables;

    public ReadOnlyTableProvider(String typeName, Map<String, BeamSqlTable> tables) {
        this.typeName = typeName;
        this.tables = tables;
    }

    @Override
    public String getTableType() {
        return this.typeName;
    }

    @Override
    public void createTable(Table table) {
        throw new UnsupportedOperationException("ReadOnlyTableProvider does not support table creation");
    }

    @Override
    public void dropTable(String tableName) {
        throw new UnsupportedOperationException("ReadOnlyTableProvider does not support table deletion");
    }

    @Override
    public Map<String, Table> getTables() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<String, BeamSqlTable> table : this.tables.entrySet()) {
            map.put((Object)table.getKey(), (Object)Table.builder().type(this.getTableType()).name(table.getKey()).schema(Schema.builder().build()).build());
        }
        return map.build();
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        return this.tables.get(table.getName());
    }
}

