/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperation;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPUtil;
import org.apache.beam.sdk.schemas.Schema;

public class CEPMeasure
implements Serializable {
    private final String outTableName;
    private final CEPOperation opr;
    private final CEPFieldRef fieldRef;
    private final Schema.FieldType fieldType;

    public CEPMeasure(Schema streamSchema, String outTableName, CEPOperation opr) {
        this.outTableName = outTableName;
        this.opr = opr;
        this.fieldRef = CEPUtil.getFieldRef(opr);
        this.fieldType = CEPUtil.getFieldType(streamSchema, opr);
    }

    public String getName() {
        return this.outTableName;
    }

    public CEPOperation getOperation() {
        return this.opr;
    }

    public CEPFieldRef getField() {
        return this.fieldRef;
    }

    public Schema.FieldType getType() {
        return this.fieldType;
    }
}

