/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamJavaTypeFactory;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.DataContext;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.GotoExpressionKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Node;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Statement;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexSimplify;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexUtil;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ScriptEvaluator;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class BeamCalcRel
extends AbstractBeamCalcRel {
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private static final ParameterExpression outputSchemaParam = Expressions.parameter(Schema.class, (String)"outputSchema");
    private static final ParameterExpression processContextParam = Expressions.parameter(DoFn.ProcessContext.class, (String)"c");
    private static final Map<Schema.TypeName, Type> rawTypeMap = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte.class).put((Object)Schema.TypeName.INT16, Short.class).put((Object)Schema.TypeName.INT32, Integer.class).put((Object)Schema.TypeName.INT64, Long.class).put((Object)Schema.TypeName.FLOAT, Float.class).put((Object)Schema.TypeName.DOUBLE, Double.class).build();
    private static final DataContext CONTEXT_INSTANCE = new SlimDataContext();

    public BeamCalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexProgram program) {
        super(cluster, traits, input, program);
    }

    public Calc copy(RelTraitSet traitSet, RelNode input, RexProgram program) {
        return new BeamCalcRel(this.getCluster(), traitSet, input, program);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private static Expression castOutput(Expression value, Schema.FieldType toType) {
        Expression returnValue = value;
        if (value.getType() == Object.class || !(value.getType() instanceof Class)) {
            returnValue = value;
        } else if (CalciteUtils.isDateTimeType(toType) && !Types.isAssignableFrom(ReadableInstant.class, (Type)((Class)value.getType()))) {
            returnValue = BeamCalcRel.castOutputTime(value, toType);
        } else if (toType.getTypeName() == Schema.TypeName.DECIMAL && !Types.isAssignableFrom(BigDecimal.class, (Type)((Class)value.getType()))) {
            returnValue = Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{value});
        } else if (toType.getTypeName() == Schema.TypeName.BYTES && Types.isAssignableFrom(ByteString.class, (Type)((Class)value.getType()))) {
            returnValue = Expressions.condition((Expression)Expressions.equal((Expression)value, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)Expressions.call((Expression)value, (String)"getBytes", (Expression[])new Expression[0]));
        } else if (((Class)value.getType()).isPrimitive() || Types.isAssignableFrom(Number.class, (Type)((Class)value.getType()))) {
            Type rawType = rawTypeMap.get(toType.getTypeName());
            if (rawType != null) {
                returnValue = Types.castIfNecessary((Type)rawType, (Expression)value);
            }
        } else if (Types.isAssignableFrom(Iterable.class, (Type)value.getType())) {
            returnValue = Expressions.convert_((Expression)value, Object.class);
        }
        returnValue = Expressions.condition((Expression)Expressions.equal((Expression)value, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)returnValue);
        return returnValue;
    }

    private static Expression castOutputTime(Expression value, Schema.FieldType toType) {
        Expression valueDateTime = value;
        if (CalciteUtils.TIMESTAMP.typesEqual(toType) || CalciteUtils.NULLABLE_TIMESTAMP.typesEqual(toType)) {
            if (value.getType() == Timestamp.class) {
                valueDateTime = Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG.method, (Expression[])new Expression[]{valueDateTime});
            }
            valueDateTime = Expressions.new_(Instant.class, (Expression[])new Expression[]{valueDateTime});
        } else if (CalciteUtils.TIME.typesEqual(toType) || CalciteUtils.NULLABLE_TIME.typesEqual(toType)) {
            if (value.getType() == Time.class) {
                valueDateTime = Expressions.call((Method)BuiltInMethod.TIME_TO_INT.method, (Expression[])new Expression[]{valueDateTime});
            } else if (value.getType() == Long.class) {
                valueDateTime = Expressions.unbox((Expression)valueDateTime);
            }
            valueDateTime = Expressions.multiply((Expression)valueDateTime, (Expression)Expressions.constant((Object)1000000L));
            valueDateTime = Expressions.call(LocalTime.class, (String)"ofNanoOfDay", (Expression[])new Expression[]{valueDateTime});
        } else if (CalciteUtils.DATE.typesEqual(toType) || CalciteUtils.NULLABLE_DATE.typesEqual(toType)) {
            if (value.getType() == Date.class) {
                valueDateTime = Expressions.call((Method)BuiltInMethod.DATE_TO_INT.method, (Expression[])new Expression[]{valueDateTime});
            } else if (value.getType() == Long.class) {
                valueDateTime = Expressions.unbox((Expression)valueDateTime);
            }
            valueDateTime = Expressions.call(LocalDate.class, (String)"ofEpochDay", (Expression[])new Expression[]{valueDateTime});
        } else {
            throw new UnsupportedOperationException("Unknown DateTime type " + toType);
        }
        if (!((Class)value.getType()).isPrimitive()) {
            valueDateTime = Expressions.condition((Expression)Expressions.equal((Expression)value, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)valueDateTime);
        }
        return valueDateTime;
    }

    private static Expression nullOr(Expression field, Expression ifNotNull) {
        return Expressions.condition((Expression)Expressions.equal((Expression)field, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)Expressions.box((Expression)ifNotNull));
    }

    public static abstract class WrappedList<T>
    extends AbstractList<T> {
        private final List<Object> values;

        protected WrappedList(List<Object> values) {
            this.values = values;
        }

        @Override
        public T get(int index) {
            return this.value(this.values.get(index));
        }

        protected abstract T value(Object var1);

        @Override
        public int size() {
            return this.values.size();
        }
    }

    public static abstract class WrappedMap<V>
    extends AbstractMap<Object, V> {
        private final Map<Object, Object> map;

        protected WrappedMap(Map<Object, Object> map) {
            this.map = map;
        }

        @Override
        public Set<Map.Entry<Object, V>> entrySet() {
            return Maps.transformValues(this.map, val -> val == null ? null : this.value(val)).entrySet();
        }

        @Override
        public V get(Object key) {
            return this.value(this.map.get(key));
        }

        protected abstract V value(Object var1);
    }

    public static abstract class WrappedRow
    extends AbstractList<Object> {
        private final Row row;

        protected WrappedRow(Row row) {
            this.row = row;
        }

        @Override
        public Object get(int index) {
            return this.field(this.row, index);
        }

        protected abstract Object field(Row var1, int var2);

        @Override
        public int size() {
            return this.row.getFieldCount();
        }
    }

    private static class SlimDataContext
    implements DataContext {
        private SlimDataContext() {
        }

        public SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            if (name.equals(DataContext.Variable.UTC_TIMESTAMP.camelName) || name.equals(DataContext.Variable.CURRENT_TIMESTAMP.camelName) || name.equals(DataContext.Variable.LOCAL_TIMESTAMP.camelName)) {
                return System.currentTimeMillis();
            }
            return null;
        }
    }

    private static class InputGetterImpl
    implements RexToLixTranslator.InputGetter {
        private static final Map<Schema.TypeName, Class> TYPE_CONVERSION_MAP = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte.class).put((Object)Schema.TypeName.BYTES, byte[].class).put((Object)Schema.TypeName.INT16, Short.class).put((Object)Schema.TypeName.INT32, Integer.class).put((Object)Schema.TypeName.INT64, Long.class).put((Object)Schema.TypeName.DECIMAL, BigDecimal.class).put((Object)Schema.TypeName.FLOAT, Float.class).put((Object)Schema.TypeName.DOUBLE, Double.class).put((Object)Schema.TypeName.STRING, String.class).put((Object)Schema.TypeName.DATETIME, ReadableInstant.class).put((Object)Schema.TypeName.BOOLEAN, Boolean.class).put((Object)Schema.TypeName.MAP, Map.class).put((Object)Schema.TypeName.ARRAY, Collection.class).put((Object)Schema.TypeName.ITERABLE, Iterable.class).put((Object)Schema.TypeName.ROW, Row.class).build();
        private static final Map<String, Class> LOGICAL_TYPE_TO_BASE_TYPE_MAP = ImmutableMap.builder().put((Object)SqlTypes.DATE.getIdentifier(), Long.class).put((Object)SqlTypes.TIME.getIdentifier(), Long.class).put((Object)"SqlTimeWithLocalTzType", ReadableInstant.class).put((Object)"SqlTimestampWithLocalTzType", ReadableInstant.class).put((Object)"SqlCharType", String.class).build();
        private final Expression input;
        private final Schema inputSchema;

        private InputGetterImpl(Expression input, Schema inputSchema) {
            this.input = input;
            this.inputSchema = inputSchema;
        }

        public Expression field(BlockBuilder list, int index, Type storageType) {
            return InputGetterImpl.value(list, index, storageType, this.input, this.inputSchema);
        }

        private static Expression value(BlockBuilder list, int index, Type storageType, Expression input, Schema schema) {
            if (index >= schema.getFieldCount() || index < 0) {
                throw new IllegalArgumentException("Unable to find value #" + index);
            }
            Expression expression = list.append(list.newName("current"), input);
            Schema.FieldType fromType = schema.getField(index).getType();
            Class convertTo = null;
            convertTo = storageType == Object.class ? Object.class : (fromType.getTypeName().isLogicalType() ? LOGICAL_TYPE_TO_BASE_TYPE_MAP.get(fromType.getLogicalType().getIdentifier()) : TYPE_CONVERSION_MAP.get(fromType.getTypeName()));
            if (convertTo == null) {
                throw new UnsupportedOperationException("Unable to get " + fromType.getTypeName());
            }
            UnaryExpression value = Expressions.convert_((Expression)Expressions.call((Expression)expression, (String)"getBaseValue", (Expression[])new Expression[]{Expressions.constant((Object)index), Expressions.constant((Object)convertTo)}), (Type)convertTo);
            return storageType != Object.class ? InputGetterImpl.value((Expression)value, fromType) : value;
        }

        private static Expression value(Expression value, Schema.FieldType type) {
            if (type.getTypeName().isLogicalType()) {
                String logicalId = type.getLogicalType().getIdentifier();
                if (SqlTypes.TIME.getIdentifier().equals(logicalId)) {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.divide((Expression)value, (Expression)Expressions.constant((Object)1000000L)));
                }
                if (SqlTypes.DATE.getIdentifier().equals(logicalId)) {
                    return value;
                }
                if (!"SqlCharType".equals(logicalId)) {
                    throw new UnsupportedOperationException("Unknown LogicalType " + type.getLogicalType().getIdentifier());
                }
            } else {
                if (type.getTypeName().isMapType()) {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.map(value, type.getMapValueType()));
                }
                if (CalciteUtils.isDateTimeType(type)) {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)value, (String)"getMillis", (Expression[])new Expression[0]));
                }
                if (type.getTypeName().isCompositeType()) {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.row(value, type.getRowSchema()));
                }
                if (type.getTypeName().isCollectionType()) {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.list(value, type.getCollectionElementType()));
                }
                if (type.getTypeName() == Schema.TypeName.BYTES) {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.new_(ByteString.class, (Expression[])new Expression[]{Types.castIfNecessary(byte[].class, (Expression)value)}));
                }
            }
            return value;
        }

        private static Expression list(Expression input, Schema.FieldType elementType) {
            ParameterExpression value = Expressions.parameter(Object.class);
            BlockBuilder block = new BlockBuilder();
            block.add(InputGetterImpl.value((Expression)value, elementType));
            return Expressions.new_(WrappedList.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(List.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"value", (Iterable)ImmutableList.of((Object)value), (BlockStatement)block.toBlock())));
        }

        private static Expression map(Expression input, Schema.FieldType mapValueType) {
            ParameterExpression value = Expressions.parameter(Object.class);
            BlockBuilder block = new BlockBuilder();
            block.add(InputGetterImpl.value((Expression)value, mapValueType));
            return Expressions.new_(WrappedMap.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(Map.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"value", (Iterable)ImmutableList.of((Object)value), (BlockStatement)block.toBlock())));
        }

        private static Expression row(Expression input, Schema schema) {
            ParameterExpression row = Expressions.parameter(Row.class);
            ParameterExpression index = Expressions.parameter(Integer.TYPE);
            BlockBuilder body = new BlockBuilder(false);
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                BlockBuilder list = new BlockBuilder(false, body);
                Expression returnValue = InputGetterImpl.value(list, i, null, (Expression)row, schema);
                list.append(returnValue);
                body.append("if i=" + i, Expressions.block((Statement[])new Statement[]{Expressions.ifThen((Expression)Expressions.equal((Expression)index, (Expression)Expressions.constant((Object)i, Integer.TYPE)), (Node)list.toBlock())}));
            }
            body.add((Statement)Expressions.throw_((Expression)Expressions.new_(IndexOutOfBoundsException.class)));
            return Expressions.new_(WrappedRow.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(Row.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"field", (Iterable)ImmutableList.of((Object)row, (Object)index), (BlockStatement)body.toBlock())));
        }
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private final String processElementBlock;
        private final Schema outputSchema;
        @Nullable
        private transient ScriptEvaluator se = null;

        public CalcFn(String processElementBlock, Schema outputSchema) {
            this.processElementBlock = processElementBlock;
            this.outputSchema = outputSchema;
        }

        ScriptEvaluator compile() {
            ScriptEvaluator se = new ScriptEvaluator();
            se.setParameters(new String[]{outputSchemaParam.name, processContextParam.name, DataContext.ROOT.name}, new Class[]{(Class)outputSchemaParam.getType(), (Class)processContextParam.getType(), (Class)DataContext.ROOT.getType()});
            try {
                se.cook(this.processElementBlock);
            }
            catch (CompileException e) {
                throw new UnsupportedOperationException("Could not compile CalcFn: " + this.processElementBlock, e);
            }
            return se;
        }

        @DoFn.Setup
        public void setup() {
            this.se = this.compile();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            assert (this.se != null);
            try {
                this.se.evaluate(new Object[]{this.outputSchema, c, CONTEXT_INSTANCE});
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("CalcFn failed to evaluate: " + this.processElementBlock, e.getCause());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Method attachValues;
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object[])new Object[]{BeamCalcRel.class.getSimpleName(), pinput});
            PCollection upstream = pinput.get(0);
            Schema outputSchema = CalciteUtils.toSchema(BeamCalcRel.this.getRowType());
            SqlConformanceEnum conformance = SqlConformanceEnum.MYSQL_5;
            JavaTypeFactory typeFactory = BeamJavaTypeFactory.INSTANCE;
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)BeamCalcRel.this.getRowType(), (JavaRowFormat)JavaRowFormat.ARRAY, (boolean)false);
            UnaryExpression input = Expressions.convert_((Expression)Expressions.call((Expression)processContextParam, (String)"element", (Expression[])new Expression[0]), Row.class);
            RexBuilder rexBuilder = BeamCalcRel.this.getCluster().getRexBuilder();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(BeamCalcRel.this.getInput());
            RexSimplify simplify = new RexSimplify(rexBuilder, predicates, RexUtil.EXECUTOR);
            RexProgram program = BeamCalcRel.this.getProgram().normalize(rexBuilder, simplify);
            Expression condition = RexToLixTranslator.translateCondition((RexProgram)program, (JavaTypeFactory)typeFactory, (BlockBuilder)builder, (RexToLixTranslator.InputGetter)new InputGetterImpl((Expression)input, upstream.getSchema()), null, (SqlConformance)conformance);
            List expressions = RexToLixTranslator.translateProjects((RexProgram)program, (JavaTypeFactory)typeFactory, (SqlConformance)conformance, (BlockBuilder)builder, (PhysType)physType, (Expression)DataContext.ROOT, (RexToLixTranslator.InputGetter)new InputGetterImpl((Expression)input, upstream.getSchema()), null);
            boolean verifyRowValues = ((BeamSqlPipelineOptions)pinput.getPipeline().getOptions().as(BeamSqlPipelineOptions.class)).getVerifyRowValues();
            ArrayList listValues = Lists.newArrayListWithCapacity((int)expressions.size());
            for (int index = 0; index < expressions.size(); ++index) {
                Expression value = (Expression)expressions.get(index);
                Schema.FieldType toType = outputSchema.getField(index).getType();
                listValues.add(BeamCalcRel.castOutput(value, toType));
            }
            Method newArrayList = Types.lookupMethod(Arrays.class, (String)"asList", (Class[])new Class[0]);
            MethodCallExpression valueList = Expressions.call((Method)newArrayList, (Iterable)listValues);
            MethodCallExpression output = Expressions.call(Row.class, (String)"withSchema", (Expression[])new Expression[]{outputSchemaParam});
            if (verifyRowValues) {
                attachValues = Types.lookupMethod(Row.Builder.class, (String)"addValues", (Class[])new Class[]{List.class});
                output = Expressions.call((Expression)output, (Method)attachValues, (Expression[])new Expression[]{valueList});
                output = Expressions.call((Expression)output, (String)"build", (Expression[])new Expression[0]);
            } else {
                attachValues = Types.lookupMethod(Row.Builder.class, (String)"attachValues", (Class[])new Class[]{List.class});
                output = Expressions.call((Expression)output, (Method)attachValues, (Expression[])new Expression[]{valueList});
            }
            builder.add((Statement)Expressions.ifThen((Expression)condition, (Node)Expressions.makeGoto((GotoExpressionKind)GotoExpressionKind.Sequence, null, (Expression)Expressions.call((Expression)processContextParam, (Method)Types.lookupMethod(DoFn.ProcessContext.class, (String)"output", (Class[])new Class[]{Object.class}), (Expression[])new Expression[]{output}))));
            CalcFn calcFn = new CalcFn(builder.toBlock().toString(), outputSchema);
            calcFn.compile();
            PCollection projectStream = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)calcFn))).setRowSchema(outputSchema);
            return projectStream;
        }
    }
}

