/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.SqlConversionException;
import org.apache.beam.sdk.extensions.sql.impl.TableResolutionUtils;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.RelMdNodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Contexts;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Planner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RuleSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.ValidationException;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteQueryPlanner
implements QueryPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(CalciteQueryPlanner.class);
    private final Planner planner;
    private final JdbcConnection connection;

    public CalciteQueryPlanner(JdbcConnection connection, RuleSet[] ruleSets) {
        this.connection = connection;
        this.planner = Frameworks.getPlanner((FrameworkConfig)this.defaultConfig(connection, ruleSets));
    }

    public FrameworkConfig defaultConfig(JdbcConnection connection, RuleSet[] ruleSets) {
        CalciteConnectionConfig config = connection.config();
        SqlParser.ConfigBuilder parserConfig = SqlParser.configBuilder().setQuotedCasing(config.quotedCasing()).setUnquotedCasing(config.unquotedCasing()).setQuoting(config.quoting()).setConformance(config.conformance()).setCaseSensitive(config.caseSensitive());
        SqlParserImplFactory parserFactory = (SqlParserImplFactory)config.parserFactory(SqlParserImplFactory.class, null);
        if (parserFactory != null) {
            parserConfig.setParserFactory(parserFactory);
        }
        SchemaPlus schema = connection.getRootSchema();
        SchemaPlus defaultSchema = connection.getCurrentSchemaPlus();
        ImmutableList traitDefs = ImmutableList.of((Object)ConventionTraitDef.INSTANCE);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)schema), (List)ImmutableList.of((Object)defaultSchema.getName()), (RelDataTypeFactory)connection.getTypeFactory(), connection.config());
        SqlOperatorTable opTab0 = (SqlOperatorTable)connection.config().fun(SqlOperatorTable.class, (Object)SqlStdOperatorTable.instance());
        return Frameworks.newConfigBuilder().parserConfig(parserConfig.build()).defaultSchema(defaultSchema).traitDefs((List)traitDefs).context(Contexts.of((Object)connection.config())).ruleSets(ruleSets).costFactory((RelOptCostFactory)BeamCostModel.FACTORY).typeSystem(connection.getTypeFactory().getTypeSystem()).operatorTable(ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{opTab0, catalogReader})).build();
    }

    @Override
    public SqlNode parse(String sqlStatement) throws ParseException {
        SqlNode parsed;
        try {
            parsed = this.planner.parse(sqlStatement);
        }
        catch (SqlParseException e) {
            throw new ParseException(String.format("Unable to parse query %s", sqlStatement), e);
        }
        finally {
            this.planner.close();
        }
        return parsed;
    }

    @Override
    public BeamRelNode convertToBeamRel(String sqlStatement, QueryPlanner.QueryParameters queryParameters) throws ParseException, SqlConversionException {
        BeamRelNode beamRelNode;
        Preconditions.checkArgument((queryParameters.getKind() == QueryPlanner.QueryParameters.Kind.NONE ? 1 : 0) != 0, (Object)"Beam SQL Calcite dialect does not yet support query parameters.");
        try {
            SqlNode parsed = this.planner.parse(sqlStatement);
            TableResolutionUtils.setupCustomTableResolution(this.connection, parsed);
            SqlNode validated = this.planner.validate(parsed);
            LOG.info("SQL:\n" + validated);
            RelRoot root = this.planner.rel(validated);
            LOG.info("SQLPlan>\n" + RelOptUtil.toString((RelNode)root.rel));
            RelTraitSet desiredTraits = root.rel.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE).replace((RelTrait)root.collation).simplify();
            root.rel.getCluster().setMetadataProvider(ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)NonCumulativeCostImpl.SOURCE, (Object)RelMdNodeStats.SOURCE, (Object)root.rel.getCluster().getMetadataProvider())));
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)root.rel.getCluster().getMetadataProvider()));
            root.rel.getCluster().invalidateMetadataQuery();
            beamRelNode = (BeamRelNode)this.planner.transform(0, desiredTraits, root.rel);
            LOG.info("BEAMPlan>\n" + RelOptUtil.toString((RelNode)beamRelNode));
        }
        catch (RelOptPlanner.CannotPlanException | RelConversionException e) {
            throw new SqlConversionException(String.format("Unable to convert query %s", sqlStatement), e);
        }
        catch (SqlParseException | ValidationException e) {
            throw new ParseException(String.format("Unable to parse query %s", sqlStatement), e);
        }
        finally {
            this.planner.close();
        }
        return beamRelNode;
    }

    public static class NonCumulativeCostImpl
    implements MetadataHandler<BuiltInMetadata.NonCumulativeCost> {
        public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.NON_CUMULATIVE_COST.method, (MetadataHandler)new NonCumulativeCostImpl());

        public MetadataDef<BuiltInMetadata.NonCumulativeCost> getDef() {
            return BuiltInMetadata.NonCumulativeCost.DEF;
        }

        public RelOptCost getNonCumulativeCost(RelNode rel, RelMetadataQuery mq) {
            if (!(rel instanceof BeamRelNode)) {
                return rel.computeSelfCost(rel.getCluster().getPlanner(), mq);
            }
            List<List> costKeys = mq.map.entrySet().stream().filter(entry -> entry.getValue() instanceof BeamCostModel).filter(entry -> ((BeamCostModel)entry.getValue()).isInfinite()).map(Map.Entry::getKey).collect(Collectors.toList());
            costKeys.forEach(mq.map::remove);
            return ((BeamRelNode)rel).beamComputeSelfCost(rel.getCluster().getPlanner(), mq);
        }
    }
}

