/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.avro;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.meta.provider.avro.AutoValue_GenericRecordWriteConverter;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

@AutoValue
public abstract class GenericRecordWriteConverter
extends PTransform<PCollection<Row>, PCollection<GenericRecord>>
implements Serializable {
    public abstract org.apache.beam.sdk.schemas.Schema beamSchema();

    public static Builder builder() {
        return new AutoValue_GenericRecordWriteConverter.Builder();
    }

    public PCollection<GenericRecord> expand(PCollection<Row> input) {
        return ((PCollection)input.apply("RowsToGenericRecord", (PTransform)ParDo.of((DoFn)new DoFn<Row, GenericRecord>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                GenericRecord genericRecord = AvroUtils.toGenericRecord((Row)((Row)c.element()), (Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)GenericRecordWriteConverter.this.beamSchema()));
                c.output((Object)genericRecord);
            }
        }))).setCoder((Coder)AvroCoder.of(GenericRecord.class, (Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)this.beamSchema())));
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract Builder beamSchema(org.apache.beam.sdk.schemas.Schema var1);

        public abstract GenericRecordWriteConverter build();
    }
}

