/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsub;

import com.alibaba.fastjson.JSONObject;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.AutoValue_PubsubJsonTableProvider_PubsubIOTableConfiguration;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubIOJsonTable;
import org.apache.beam.sdk.schemas.Schema;

@Internal
@Experimental
public class PubsubJsonTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public String getTableType() {
        return "pubsub";
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table tableDefintion) {
        JSONObject tableProperties = tableDefintion.getProperties();
        String timestampAttributeKey = tableProperties.getString("timestampAttributeKey");
        String deadLetterQueue = tableProperties.getString("deadLetterQueue");
        this.validateDlq(deadLetterQueue);
        Schema schema = tableDefintion.getSchema();
        this.validateEventTimestamp(schema);
        PubsubIOTableConfiguration config = PubsubIOTableConfiguration.builder().setSchema(schema).setTimestampAttribute(timestampAttributeKey).setDeadLetterQueue(deadLetterQueue).setTopic(tableDefintion.getLocation()).setUseFlatSchema(!this.definesAttributeAndPayload(schema)).build();
        return PubsubIOJsonTable.withConfiguration(config);
    }

    private void validateEventTimestamp(Schema schema) {
        if (!this.fieldPresent(schema, "event_timestamp", CalciteUtils.TIMESTAMP)) {
            throw new InvalidTableException("Unsupported schema specified for Pubsub source in CREATE TABLE.CREATE TABLE for Pubsub topic must include at least 'event_timestamp' field of type 'TIMESTAMP'");
        }
    }

    private boolean definesAttributeAndPayload(Schema schema) {
        return this.fieldPresent(schema, "attributes", Schema.FieldType.map((Schema.FieldType)CalciteUtils.VARCHAR.withNullable(false), (Schema.FieldType)CalciteUtils.VARCHAR)) && schema.hasField("payload") && Schema.TypeName.ROW.equals((Object)schema.getField("payload").getType().getTypeName());
    }

    private boolean fieldPresent(Schema schema, String field, Schema.FieldType expectedType) {
        return schema.hasField(field) && expectedType.equivalent(schema.getField(field).getType(), Schema.EquivalenceNullablePolicy.IGNORE);
    }

    private void validateDlq(String deadLetterQueue) {
        if (deadLetterQueue != null && deadLetterQueue.isEmpty()) {
            throw new InvalidTableException("Dead letter queue topic name is not specified");
        }
    }

    @AutoValue
    public static abstract class PubsubIOTableConfiguration
    implements Serializable {
        public boolean useDlq() {
            return this.getDeadLetterQueue() != null;
        }

        public boolean useTimestampAttribute() {
            return this.getTimestampAttribute() != null;
        }

        abstract boolean getUseFlatSchema();

        @Nullable
        abstract String getTimestampAttribute();

        @Nullable
        abstract String getDeadLetterQueue();

        abstract String getTopic();

        public abstract Schema getSchema();

        static Builder builder() {
            return new AutoValue_PubsubJsonTableProvider_PubsubIOTableConfiguration.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setUseFlatSchema(boolean var1);

            abstract Builder setSchema(Schema var1);

            abstract Builder setTimestampAttribute(String var1);

            abstract Builder setDeadLetterQueue(String var1);

            abstract Builder setTopic(String var1);

            abstract PubsubIOTableConfiguration build();
        }
    }
}

