/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Uncollect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlValidatorUtil;

public class BeamUnnestRel
extends Uncollect
implements BeamRelNode {
    private final RelDataType unnestType;
    private final int unnestIndex;

    public BeamUnnestRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType unnestType, int unnestIndex) {
        super(cluster, traitSet, input);
        this.unnestType = unnestType;
        this.unnestIndex = unnestIndex;
    }

    public Uncollect copy(RelTraitSet traitSet, RelNode input) {
        return new BeamUnnestRel(this.getCluster(), traitSet, input, this.unnestType, this.unnestIndex);
    }

    protected RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType((RelDataType)this.input.getRowType(), (RelDataType)this.unnestType, (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, (List)ImmutableList.of());
    }

    @Override
    public NodeStats estimateNodeStats(RelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats(this.input, mq).multiply(2.0);
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats(this, mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("unnestIndex", (Object)Integer.toString(this.unnestIndex));
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private static class UnnestFn
    extends DoFn<Row, Row> {
        private final Schema outputSchema;
        private final int unnestIndex;

        private UnnestFn(Schema outputSchema, int unnestIndex) {
            this.outputSchema = outputSchema;
            this.unnestIndex = unnestIndex;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element Row row, DoFn.OutputReceiver<Row> out) {
            Collection rawValues = row.getArray(this.unnestIndex);
            if (rawValues == null) {
                return;
            }
            Schema.TypeName typeName = this.outputSchema.getField(this.unnestIndex).getType().getCollectionElementType().getTypeName();
            for (Object uncollectedValue : rawValues) {
                if (typeName.equals((Object)Schema.TypeName.ROW)) {
                    Row nestedRow = (Row)uncollectedValue;
                    out.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(row.getBaseValues()).addValues(nestedRow.getBaseValues()).build());
                    continue;
                }
                out.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(row.getBaseValues()).addValue(uncollectedValue).build());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            PCollection outer = pinput.get(0);
            Schema joinedSchema = CalciteUtils.toSchema(BeamUnnestRel.this.rowType);
            return ((PCollection)outer.apply((PTransform)ParDo.of((DoFn)new UnnestFn(joinedSchema, BeamUnnestRel.this.unnestIndex)))).setRowSchema(joinedSchema);
        }
    }
}

