/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSetOperatorRelBase;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.SetOp;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Union;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;

public class BeamUnionRel
extends Union
implements BeamRelNode {
    public BeamUnionRel(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, all);
    }

    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new BeamUnionRel(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new BeamSetOperatorRelBase(this, BeamSetOperatorRelBase.OpType.UNION, this.all);
    }

    @Override
    public NodeStats estimateNodeStats(RelMetadataQuery mq) {
        NodeStats summationOfEstimates = this.inputs.stream().map(input -> BeamSqlRelUtils.getNodeStats(input, mq)).reduce(NodeStats.create(0.0, 0.0, 0.0), NodeStats::plus);
        summationOfEstimates = this.all ? summationOfEstimates : summationOfEstimates.multiply(0.5);
        return summationOfEstimates;
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        NodeStats summationOfEstimates = this.inputs.stream().map(input -> BeamSqlRelUtils.getNodeStats(input, mq)).reduce(NodeStats.create(0.0, 0.0, 0.0), NodeStats::plus);
        return BeamCostModel.FACTORY.makeCost(summationOfEstimates.getRowCount(), summationOfEstimates.getRate());
    }
}

