/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.util;

import java.sql.Timestamp;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.util.SqlString;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.UnmodifiableArrayList;

public class SqlBuilder {
    private final StringBuilder buf;
    private final SqlDialect dialect;

    public SqlBuilder(SqlDialect dialect) {
        assert (dialect != null);
        this.dialect = dialect;
        this.buf = new StringBuilder();
    }

    public SqlBuilder(SqlDialect dialect, String s) {
        assert (dialect != null);
        this.dialect = dialect;
        this.buf = new StringBuilder(s);
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }

    public int length() {
        return this.buf.length();
    }

    public void clear() {
        this.buf.setLength(0);
    }

    public String toString() {
        return this.getSql();
    }

    public String getSql() {
        return this.buf.toString();
    }

    public String getSqlAndClear() {
        String str = this.buf.toString();
        this.clear();
        return str;
    }

    public SqlBuilder append(SqlString s) {
        this.buf.append(s.getSql());
        return this;
    }

    public SqlBuilder append(String s) {
        this.buf.append(s);
        return this;
    }

    public SqlBuilder append(char c) {
        this.buf.append(c);
        return this;
    }

    public SqlBuilder append(long n) {
        this.buf.append(n);
        return this;
    }

    public SqlBuilder identifier(String name) {
        this.dialect.quoteIdentifier(this.buf, name);
        return this;
    }

    public SqlBuilder identifier(String ... names) {
        this.dialect.quoteIdentifier(this.buf, UnmodifiableArrayList.of(names));
        return this;
    }

    public SqlBuilder identifier(List<String> names) {
        this.dialect.quoteIdentifier(this.buf, names);
        return this;
    }

    public SqlString toSqlString() {
        return new SqlString(this.dialect, this.buf.toString());
    }

    public SqlBuilder literal(String s) {
        this.buf.append(s == null ? "null" : this.dialect.quoteStringLiteral(s));
        return this;
    }

    public SqlBuilder literal(Timestamp timestamp) {
        this.buf.append(timestamp == null ? "null" : this.dialect.quoteTimestampLiteral(timestamp));
        return this;
    }

    public int indexOf(String str) {
        return this.buf.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.buf.indexOf(str, fromIndex);
    }

    public SqlBuilder insert(int offset, String str) {
        this.buf.insert(offset, str);
        return this;
    }
}

