/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.ExplicitOperatorBinding;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCallBinding;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.InferTypes;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.OperandTypes;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Litmus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Static;

public class SqlInOperator
extends SqlBinaryOperator {
    private final boolean isNotIn;

    SqlInOperator(boolean isNotIn) {
        super(isNotIn ? "NOT IN" : "IN", SqlKind.IN, 32, true, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, null);
        this.isNotIn = isNotIn;
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        if (count == 0) {
            return litmus.fail("wrong operand count {} for {}", count, this);
        }
        return litmus.succeed();
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType rightType;
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        SqlNode left = operands.get(0);
        SqlNode right = operands.get(1);
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        RelDataType leftType = validator.deriveType(scope, left);
        if (right instanceof SqlNodeList) {
            ArrayList<RelDataType> rightTypeList = new ArrayList<RelDataType>();
            SqlNodeList nodeList = (SqlNodeList)right;
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode node = nodeList.get(i);
                RelDataType nodeType = validator.deriveType(scope, node);
                rightTypeList.add(nodeType);
            }
            rightType = typeFactory.leastRestrictive(rightTypeList);
            if (null == rightType) {
                throw validator.newValidationError(right, Static.RESOURCE.incompatibleTypesInList());
            }
            ((SqlValidatorImpl)validator).setValidatedNodeType(nodeList, rightType);
        } else {
            rightType = validator.deriveType(scope, right);
        }
        RelDataType leftRowType = SqlTypeUtil.promoteToRowType(typeFactory, leftType, null);
        RelDataType rightRowType = SqlTypeUtil.promoteToRowType(typeFactory, rightType, null);
        ComparableOperandTypeChecker checker = (ComparableOperandTypeChecker)OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED;
        if (!checker.checkOperandTypes(new ExplicitOperatorBinding(new SqlCallBinding(validator, scope, call), ImmutableList.of(leftRowType, rightRowType)))) {
            throw validator.newValidationError(call, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.IN.getName()));
        }
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlInOperator.anyNullable(leftRowType.getFieldList()) || SqlInOperator.anyNullable(rightRowType.getFieldList()));
    }

    private static boolean anyNullable(List<RelDataTypeField> fieldList) {
        for (RelDataTypeField field : fieldList) {
            if (!field.getType().isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal == 0;
    }
}

