/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexDynamicParam;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeUtil;

public class RexTransformer {
    private RexNode root;
    private final RexBuilder rexBuilder;
    private int isParentsCount;
    private final Set<SqlOperator> transformableOperators = new HashSet<SqlOperator>();

    public RexTransformer(RexNode root, RexBuilder rexBuilder) {
        this.root = root;
        this.rexBuilder = rexBuilder;
        this.isParentsCount = 0;
        this.transformableOperators.add(SqlStdOperatorTable.AND);
        this.transformableOperators.add(SqlStdOperatorTable.EQUALS);
        this.transformableOperators.add(SqlStdOperatorTable.NOT_EQUALS);
        this.transformableOperators.add(SqlStdOperatorTable.GREATER_THAN);
        this.transformableOperators.add(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        this.transformableOperators.add(SqlStdOperatorTable.LESS_THAN);
        this.transformableOperators.add(SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
    }

    private boolean isBoolean(RexNode node) {
        RelDataType type = node.getType();
        return SqlTypeUtil.inBooleanFamily(type);
    }

    private boolean isNullable(RexNode node) {
        return node.getType().isNullable();
    }

    private boolean isTransformable(RexNode node) {
        if (0 == this.isParentsCount) {
            return false;
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            return !this.transformableOperators.contains(call.getOperator()) && this.isNullable(node);
        }
        return this.isNullable(node);
    }

    public RexNode transformNullSemantics() {
        this.root = this.transformNullSemantics(this.root);
        return this.root;
    }

    private RexNode transformNullSemantics(RexNode node) {
        RexCall call;
        assert (this.isParentsCount >= 0) : "Cannot be negative";
        if (!this.isBoolean(node)) {
            return node;
        }
        Boolean directlyUnderIs = null;
        if (node.isA(SqlKind.IS_TRUE)) {
            directlyUnderIs = Boolean.TRUE;
            ++this.isParentsCount;
        } else if (node.isA(SqlKind.IS_FALSE)) {
            directlyUnderIs = Boolean.FALSE;
            ++this.isParentsCount;
        }
        if (null != directlyUnderIs) {
            call = (RexCall)node;
            assert (this.isParentsCount > 0) : "Stack should not be empty";
            assert (1 == call.operands.size());
            RexNode operand = (RexNode)call.operands.get(0);
            if (operand instanceof RexLiteral || operand instanceof RexInputRef || operand instanceof RexDynamicParam) {
                if (this.isNullable(node)) {
                    RexNode notNullNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand);
                    RexLiteral boolNode = this.rexBuilder.makeLiteral(directlyUnderIs);
                    RexNode eqNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, operand, boolNode);
                    RexNode andBoolNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, notNullNode, eqNode);
                    return andBoolNode;
                }
                RexLiteral boolNode = this.rexBuilder.makeLiteral(directlyUnderIs);
                RexNode andBoolNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, node, boolNode);
                return andBoolNode;
            }
        }
        if (node instanceof RexCall) {
            call = (RexCall)node;
            ArrayList<RexNode> operands = new ArrayList<RexNode>();
            for (RexNode operand : call.operands) {
                operands.add(this.transformNullSemantics(operand));
            }
            if (null != directlyUnderIs) {
                --this.isParentsCount;
                directlyUnderIs = null;
                return (RexNode)operands.get(0);
            }
            if (this.transformableOperators.contains(call.getOperator())) {
                assert (2 == operands.size());
                RexNode isNotNullOne = this.isTransformable((RexNode)operands.get(0)) ? this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operands.get(0)) : null;
                RexNode isNotNullTwo = this.isTransformable(operands.get(1)) ? this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operands.get(1)) : null;
                RexNode intoFinalAnd = null;
                if (null != isNotNullOne && null != isNotNullTwo) {
                    intoFinalAnd = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, isNotNullOne, isNotNullTwo);
                } else if (null != isNotNullOne) {
                    intoFinalAnd = isNotNullOne;
                } else if (null != isNotNullTwo) {
                    intoFinalAnd = isNotNullTwo;
                }
                if (null != intoFinalAnd) {
                    RexNode andNullAndCheckNode = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, intoFinalAnd, call.clone(call.getType(), operands));
                    return andNullAndCheckNode;
                }
            }
            if (!operands.equals(call.operands)) {
                return call.clone(call.getType(), operands);
            }
        }
        return node;
    }
}

