/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan;

import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class RelTraitPropagationVisitor
extends RelVisitor {
    private final RelTraitSet baseTraits;
    private final RelOptPlanner planner;

    public RelTraitPropagationVisitor(RelOptPlanner planner, RelTraitSet baseTraits) {
        this.planner = planner;
        this.baseTraits = baseTraits;
    }

    @Override
    public void visit(RelNode rel, int ordinal, RelNode parent) {
        if (this.planner.isRegistered(rel)) {
            return;
        }
        RelTraitSet relTraits = rel.getTraitSet();
        for (int i = 0; i < this.baseTraits.size(); ++i) {
            if (i >= relTraits.size()) {
                Util.discard(RelOptUtil.addTrait(rel, this.baseTraits.getTrait(i)));
                throw new AssertionError();
            }
            assert (relTraits.getTrait(i).getTraitDef() == this.baseTraits.getTrait(i).getTraitDef());
        }
        rel.childrenAccept(this);
    }
}

