/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.ConnectionConfigImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.ConnectionProperty;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.Casing;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.Quoting;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.config.Lex;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.config.NullCollation;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.model.JsonSchema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Bug;

public enum CalciteConnectionProperty implements ConnectionProperty
{
    APPROXIMATE_DISTINCT_COUNT("approximateDistinctCount", ConnectionProperty.Type.BOOLEAN, false, false),
    APPROXIMATE_TOP_N("approximateTopN", ConnectionProperty.Type.BOOLEAN, false, false),
    APPROXIMATE_DECIMAL("approximateDecimal", ConnectionProperty.Type.BOOLEAN, false, false),
    AUTO_TEMP("autoTemp", ConnectionProperty.Type.BOOLEAN, false, false),
    MATERIALIZATIONS_ENABLED("materializationsEnabled", ConnectionProperty.Type.BOOLEAN, true, false),
    CREATE_MATERIALIZATIONS("createMaterializations", ConnectionProperty.Type.BOOLEAN, true, false),
    DEFAULT_NULL_COLLATION("defaultNullCollation", ConnectionProperty.Type.ENUM, (Object)((Object)NullCollation.HIGH), true, NullCollation.class),
    DRUID_FETCH("druidFetch", ConnectionProperty.Type.NUMBER, 16384, false),
    MODEL("model", ConnectionProperty.Type.STRING, null, false),
    LEX("lex", ConnectionProperty.Type.ENUM, (Object)((Object)Lex.ORACLE), false),
    FUN("fun", ConnectionProperty.Type.STRING, "standard", true),
    QUOTING("quoting", ConnectionProperty.Type.ENUM, null, false, Quoting.class),
    QUOTED_CASING("quotedCasing", ConnectionProperty.Type.ENUM, null, false, Casing.class),
    UNQUOTED_CASING("unquotedCasing", ConnectionProperty.Type.ENUM, null, false, Casing.class),
    CASE_SENSITIVE("caseSensitive", ConnectionProperty.Type.BOOLEAN, null, false),
    PARSER_FACTORY("parserFactory", ConnectionProperty.Type.PLUGIN, null, false),
    SCHEMA("schema", ConnectionProperty.Type.STRING, null, false),
    SCHEMA_FACTORY("schemaFactory", ConnectionProperty.Type.PLUGIN, null, false),
    SCHEMA_TYPE("schemaType", ConnectionProperty.Type.ENUM, null, false, JsonSchema.Type.class),
    SPARK("spark", ConnectionProperty.Type.BOOLEAN, false, false),
    TIME_ZONE("timeZone", ConnectionProperty.Type.STRING, null, false),
    FORCE_DECORRELATE("forceDecorrelate", ConnectionProperty.Type.BOOLEAN, true, false),
    TYPE_SYSTEM("typeSystem", ConnectionProperty.Type.PLUGIN, null, false),
    CONFORMANCE("conformance", ConnectionProperty.Type.ENUM, SqlConformanceEnum.DEFAULT, false);

    private final String camelName;
    private final ConnectionProperty.Type type;
    private final Object defaultValue;
    private final boolean required;
    private final Class valueClass;
    private static final Map<String, CalciteConnectionProperty> NAME_TO_PROPS;
    @Deprecated
    public static final CalciteConnectionProperty TIMEZONE;

    private CalciteConnectionProperty(String camelName, ConnectionProperty.Type type, Object defaultValue, boolean required) {
        this(camelName, type, defaultValue, required, null);
    }

    private CalciteConnectionProperty(String camelName, ConnectionProperty.Type type, Object defaultValue, boolean required, Class valueClass) {
        this.camelName = camelName;
        this.type = type;
        this.defaultValue = defaultValue;
        this.required = required;
        this.valueClass = type.deduceValueClass(defaultValue, valueClass);
        if (!type.valid(defaultValue, this.valueClass)) {
            throw new AssertionError((Object)camelName);
        }
    }

    @Override
    public String camelName() {
        return this.camelName;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public ConnectionProperty.Type type() {
        return this.type;
    }

    @Override
    public Class valueClass() {
        return this.valueClass;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public ConnectionConfigImpl.PropEnv wrap(Properties properties) {
        return new ConnectionConfigImpl.PropEnv(CalciteConnectionProperty.parse2(properties, NAME_TO_PROPS), this);
    }

    private static Map<ConnectionProperty, String> parse2(Properties properties, Map<String, ? extends ConnectionProperty> nameToProps) {
        Bug.upgrade("avatica-1.10");
        LinkedHashMap<ConnectionProperty, String> map = new LinkedHashMap<ConnectionProperty, String>();
        for (String name : properties.stringPropertyNames()) {
            ConnectionProperty connectionProperty = nameToProps.get(name.toUpperCase(Locale.ROOT));
            if (connectionProperty == null) continue;
            map.put(connectionProperty, properties.getProperty(name));
        }
        return map;
    }

    static {
        TIMEZONE = TIME_ZONE;
        NAME_TO_PROPS = new HashMap<String, CalciteConnectionProperty>();
        for (CalciteConnectionProperty p : CalciteConnectionProperty.values()) {
            NAME_TO_PROPS.put(p.camelName.toUpperCase(Locale.ROOT), p);
            NAME_TO_PROPS.put(p.name(), p);
        }
    }
}

