/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.UnregisteredDriver;

public class DriverVersion {
    public final int majorVersion;
    public final int minorVersion;
    public final String name;
    public final String versionString;
    public final String productName;
    public final String productVersion;
    public final boolean jdbcCompliant;
    public final int databaseMajorVersion;
    public final int databaseMinorVersion;

    public DriverVersion(String name, String versionString, String productName, String productVersion, boolean jdbcCompliant, int majorVersion, int minorVersion, int databaseMajorVersion, int databaseMinorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.name = name;
        this.versionString = versionString;
        this.productName = productName;
        this.productVersion = productVersion;
        this.jdbcCompliant = jdbcCompliant;
        this.databaseMajorVersion = databaseMajorVersion;
        this.databaseMinorVersion = databaseMinorVersion;
    }

    public static DriverVersion load(Class<? extends UnregisteredDriver> driverClass, String resourceName, String driverName, String driverVersion, String productName, String productVersion) {
        int databaseMinorVersion;
        int databaseMajorVersion;
        int minorVersion;
        int majorVersion;
        boolean jdbcCompliant;
        block10: {
            jdbcCompliant = true;
            majorVersion = 0;
            minorVersion = 0;
            databaseMajorVersion = 0;
            databaseMinorVersion = 0;
            try {
                InputStream inStream = driverClass.getClassLoader().getResourceAsStream(resourceName);
                if (inStream == null) break block10;
                Properties properties = new Properties();
                properties.load(inStream);
                driverName = properties.getProperty("driver.name");
                driverVersion = properties.getProperty("driver.version");
                productName = properties.getProperty("product.name");
                productVersion = properties.getProperty("product.version");
                jdbcCompliant = Boolean.valueOf(properties.getProperty("jdbc.compliant"));
                String[] s = driverVersion.replaceAll("-.*$", "").split("\\.");
                int major = Integer.valueOf(s[0]);
                int minor = Integer.valueOf(s[1]);
                try {
                    majorVersion = Integer.valueOf(properties.getProperty("driver.version.major"));
                }
                catch (NumberFormatException e) {
                    majorVersion = major;
                }
                try {
                    minorVersion = Integer.valueOf(properties.getProperty("driver.version.minor"));
                }
                catch (NumberFormatException e) {
                    minorVersion = minor;
                }
                try {
                    databaseMajorVersion = Integer.valueOf(properties.getProperty("database.version.major"));
                }
                catch (NumberFormatException e) {
                    databaseMajorVersion = major;
                }
                try {
                    databaseMinorVersion = Integer.valueOf(properties.getProperty("database.version.minor"));
                }
                catch (NumberFormatException e) {
                    databaseMinorVersion = minor;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new DriverVersion(driverName, driverVersion, productName, productVersion, jdbcCompliant, majorVersion, minorVersion, databaseMajorVersion, databaseMinorVersion);
    }
}

