/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.EnumerableJoin;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.EnumerableThetaJoin;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.Convention;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.AbstractRelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.InvalidRelException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinInfo;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.logical.LogicalJoin;

class EnumerableJoinRule
extends ConverterRule {
    EnumerableJoinRule() {
        super(LogicalJoin.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableJoinRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        AbstractRelNode newRel;
        RelNode right;
        LogicalJoin join = (LogicalJoin)rel;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : join.getInputs()) {
            if (!(input.getConvention() instanceof EnumerableConvention)) {
                input = EnumerableJoinRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
            }
            newInputs.add(input);
        }
        RelOptCluster cluster = join.getCluster();
        RelTraitSet traitSet = join.getTraitSet().replace(EnumerableConvention.INSTANCE);
        RelNode left = (RelNode)newInputs.get(0);
        JoinInfo info = JoinInfo.of(left, right = (RelNode)newInputs.get(1), join.getCondition());
        if (!info.isEqui() && join.getJoinType() != JoinRelType.INNER) {
            try {
                return new EnumerableThetaJoin(cluster, traitSet, left, right, join.getCondition(), join.getVariablesSet(), join.getJoinType());
            }
            catch (InvalidRelException e) {
                EnumerableRules.LOGGER.debug(e.toString());
                return null;
            }
        }
        try {
            newRel = new EnumerableJoin(cluster, join.getTraitSet().replace(EnumerableConvention.INSTANCE), left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), info.leftKeys, info.rightKeys, join.getVariablesSet(), join.getJoinType());
        }
        catch (InvalidRelException e) {
            EnumerableRules.LOGGER.debug(e.toString());
            return null;
        }
        if (!info.isEqui()) {
            newRel = new EnumerableFilter(cluster, newRel.getTraitSet(), newRel, info.getRemaining(cluster.getRexBuilder()));
        }
        return newRel;
    }
}

