/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class CalciteUtils {
    private static final Map<Integer, SqlTypeName> JAVA_TO_CALCITE_MAPPING = new HashMap<Integer, SqlTypeName>();
    private static final Map<SqlTypeName, Integer> CALCITE_TO_JAVA_MAPPING = new HashMap<SqlTypeName, Integer>();

    public static SqlTypeName toCalciteType(int type) {
        return JAVA_TO_CALCITE_MAPPING.get(type);
    }

    public static Integer toJavaType(SqlTypeName typeName) {
        return CALCITE_TO_JAVA_MAPPING.get((Object)typeName);
    }

    public static SqlTypeName getFieldType(BeamRecordSqlType schema, int index) {
        return CalciteUtils.toCalciteType(schema.getFieldTypeByIndex(index));
    }

    public static BeamRecordSqlType toBeamRowType(RelDataType tableInfo) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<Integer> fieldTypes = new ArrayList<Integer>();
        for (RelDataTypeField f : tableInfo.getFieldList()) {
            fieldNames.add(f.getName());
            fieldTypes.add(CalciteUtils.toJavaType(f.getType().getSqlTypeName()));
        }
        return BeamRecordSqlType.create(fieldNames, fieldTypes);
    }

    public static RelProtoDataType toCalciteRowType(final BeamRecordSqlType that) {
        return new RelProtoDataType(){

            @Override
            public RelDataType apply(RelDataTypeFactory a) {
                RelDataTypeFactory.FieldInfoBuilder builder = a.builder();
                for (int idx = 0; idx < that.getFieldNames().size(); ++idx) {
                    builder.add(that.getFieldNameByIndex(idx), CalciteUtils.toCalciteType(that.getFieldTypeByIndex(idx)));
                }
                return builder.build();
            }
        };
    }

    static {
        JAVA_TO_CALCITE_MAPPING.put(-6, SqlTypeName.TINYINT);
        JAVA_TO_CALCITE_MAPPING.put(5, SqlTypeName.SMALLINT);
        JAVA_TO_CALCITE_MAPPING.put(4, SqlTypeName.INTEGER);
        JAVA_TO_CALCITE_MAPPING.put(-5, SqlTypeName.BIGINT);
        JAVA_TO_CALCITE_MAPPING.put(6, SqlTypeName.FLOAT);
        JAVA_TO_CALCITE_MAPPING.put(8, SqlTypeName.DOUBLE);
        JAVA_TO_CALCITE_MAPPING.put(3, SqlTypeName.DECIMAL);
        JAVA_TO_CALCITE_MAPPING.put(1, SqlTypeName.CHAR);
        JAVA_TO_CALCITE_MAPPING.put(12, SqlTypeName.VARCHAR);
        JAVA_TO_CALCITE_MAPPING.put(91, SqlTypeName.DATE);
        JAVA_TO_CALCITE_MAPPING.put(92, SqlTypeName.TIME);
        JAVA_TO_CALCITE_MAPPING.put(93, SqlTypeName.TIMESTAMP);
        JAVA_TO_CALCITE_MAPPING.put(16, SqlTypeName.BOOLEAN);
        for (Map.Entry<Integer, SqlTypeName> pair : JAVA_TO_CALCITE_MAPPING.entrySet()) {
            CALCITE_TO_JAVA_MAPPING.put(pair.getValue(), pair.getKey());
        }
    }
}

