/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema.text;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.schema.text.BeamTextCSVTableIOReader;
import org.apache.beam.sdk.extensions.sql.impl.schema.text.BeamTextCSVTableIOWriter;
import org.apache.beam.sdk.extensions.sql.impl.schema.text.BeamTextTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.commons.csv.CSVFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamTextCSVTable
extends BeamTextTable {
    private static final Logger LOG = LoggerFactory.getLogger(BeamTextCSVTable.class);
    private CSVFormat csvFormat;

    public BeamTextCSVTable(BeamRecordSqlType beamSqlRowType, String filePattern) {
        this(beamSqlRowType, filePattern, CSVFormat.DEFAULT);
    }

    public BeamTextCSVTable(BeamRecordSqlType beamSqlRowType, String filePattern, CSVFormat csvFormat) {
        super(beamSqlRowType, filePattern);
        this.csvFormat = csvFormat;
    }

    @Override
    public PCollection<BeamRecord> buildIOReader(Pipeline pipeline) {
        return (PCollection)((PCollection)PBegin.in((Pipeline)pipeline).apply("decodeRecord", (PTransform)TextIO.read().from(this.filePattern))).apply("parseCSVLine", (PTransform)new BeamTextCSVTableIOReader(this.beamSqlRowType, this.filePattern, this.csvFormat));
    }

    @Override
    public PTransform<? super PCollection<BeamRecord>, PDone> buildIOWriter() {
        return new BeamTextCSVTableIOWriter(this.beamSqlRowType, this.filePattern, this.csvFormat);
    }
}

