/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import java.util.GregorianCalendar;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamAggregationRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Project;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.ImmutableBitSet;
import org.joda.time.Duration;

public class BeamAggregationRule
extends RelOptRule {
    public static final BeamAggregationRule INSTANCE = new BeamAggregationRule(Aggregate.class, Project.class, RelFactories.LOGICAL_BUILDER);

    public BeamAggregationRule(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
        super(BeamAggregationRule.operand(aggregateClass, BeamAggregationRule.operand(projectClass, BeamAggregationRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    public BeamAggregationRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Project project = (Project)call.rel(1);
        this.updateWindowTrigger(call, aggregate, project);
    }

    private void updateWindowTrigger(RelOptRuleCall call, Aggregate aggregate, Project project) {
        ImmutableBitSet groupByFields = aggregate.getGroupSet();
        List<RexNode> projectMapping = project.getProjects();
        GlobalWindows windowFn = new GlobalWindows();
        Repeatedly triggerFn = Repeatedly.forever((Trigger)AfterWatermark.pastEndOfWindow());
        int windowFieldIdx = -1;
        Duration allowedLatence = Duration.ZERO;
        for (int groupField : groupByFields.asList()) {
            String functionName;
            RexNode projNode = projectMapping.get(groupField);
            if (!(projNode instanceof RexCall)) continue;
            SqlOperator op = ((RexCall)projNode).op;
            ImmutableList<RexNode> parameters = ((RexCall)projNode).operands;
            switch (functionName = op.getName()) {
                case "TUMBLE": {
                    windowFieldIdx = groupField;
                    windowFn = FixedWindows.of((Duration)Duration.millis((long)this.getWindowParameterAsMillis((RexNode)parameters.get(1))));
                    if (parameters.size() != 3) break;
                    GregorianCalendar delayTime = (GregorianCalendar)((RexLiteral)parameters.get(2)).getValue();
                    triggerFn = this.createTriggerWithDelay(delayTime);
                    allowedLatence = Duration.millis((long)delayTime.getTimeInMillis());
                    break;
                }
                case "HOP": {
                    windowFieldIdx = groupField;
                    windowFn = SlidingWindows.of((Duration)Duration.millis((long)this.getWindowParameterAsMillis((RexNode)parameters.get(1)))).every(Duration.millis((long)this.getWindowParameterAsMillis((RexNode)parameters.get(2))));
                    if (parameters.size() != 4) break;
                    GregorianCalendar delayTime = (GregorianCalendar)((RexLiteral)parameters.get(3)).getValue();
                    triggerFn = this.createTriggerWithDelay(delayTime);
                    allowedLatence = Duration.millis((long)delayTime.getTimeInMillis());
                    break;
                }
                case "SESSION": {
                    windowFieldIdx = groupField;
                    windowFn = Sessions.withGapDuration((Duration)Duration.millis((long)this.getWindowParameterAsMillis((RexNode)parameters.get(1))));
                    if (parameters.size() != 3) break;
                    GregorianCalendar delayTime = (GregorianCalendar)((RexLiteral)parameters.get(2)).getValue();
                    triggerFn = this.createTriggerWithDelay(delayTime);
                    allowedLatence = Duration.millis((long)delayTime.getTimeInMillis());
                    break;
                }
            }
        }
        BeamAggregationRel newAggregator = new BeamAggregationRel(aggregate.getCluster(), aggregate.getTraitSet().replace(BeamLogicalConvention.INSTANCE), BeamAggregationRule.convert(aggregate.getInput(), aggregate.getInput().getTraitSet().replace(BeamLogicalConvention.INSTANCE)), aggregate.indicator, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList(), (WindowFn)windowFn, (Trigger)triggerFn, windowFieldIdx, allowedLatence);
        call.transformTo(newAggregator);
    }

    private Trigger createTriggerWithDelay(GregorianCalendar delayTime) {
        return Repeatedly.forever((Trigger)AfterWatermark.pastEndOfWindow().withLateFirings((Trigger.OnceTrigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(Duration.millis((long)delayTime.getTimeInMillis()))));
    }

    private long getWindowParameterAsMillis(RexNode parameterNode) {
        if (parameterNode instanceof RexLiteral) {
            return RexLiteral.intValue(parameterNode);
        }
        throw new IllegalArgumentException(String.format("[%s] is not valid.", parameterNode));
    }
}

